/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.secrets.pki;

import io.quarkus.vault.client.api.common.VaultCompletionStages;
import io.quarkus.vault.client.api.common.VaultLeasedResult;
import io.quarkus.vault.client.api.common.VaultMountableAPI;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIConfigClusterResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIConfigCrlParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIConfigIssuersResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIConfigKeysResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIConfigUrlsParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIGenerateCsrParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIGenerateCsrResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIGenerateKeyParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIGenerateRootParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIGenerateRootResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIImportResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIIssueParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIIssueResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIKeyInfo;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIListCertificatesResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIListIssuersResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIListKeysResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIListRevokedResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIListRolesResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIManageType;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIReadCertificateResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIReadClusterConfigResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIReadCrlConfigResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIReadIssuerCaCertResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIReadIssuerCaChainResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIReadIssuerCrlResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIReadIssuerDeltaCrlResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIReadIssuerUnifiedCrlResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIReadIssuerUnifiedDeltaCrlResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIReadIssuersConfigResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIReadKeysConfigResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIReadRoleResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIReadUrlsConfigResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIRequestFactory;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIRevokeIssuerResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIRevokeParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIRevokeResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIRevokeWithKeyParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIRevokeWithKeyResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIRotateCrlResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIRotateDeltaCrlResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKISignIntermediateParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKISignParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKISignResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKISignSelfIssuedResultData;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKISignVerbatimParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKITidyParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIUpdateKeyParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIUpdateRoleParams;
import io.quarkus.vault.client.common.VaultRequestExecutor;
import io.quarkus.vault.client.common.VaultResponse;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;

public class VaultSecretsPKI
extends VaultMountableAPI<VaultSecretsPKIRequestFactory> {
    public static VaultSecretsPKIRequestFactory FACTORY = VaultSecretsPKIRequestFactory.INSTANCE;

    public VaultSecretsPKI(VaultRequestExecutor executor, String mountPath, VaultSecretsPKIRequestFactory factory) {
        super(executor, factory, mountPath);
    }

    public VaultSecretsPKI(VaultRequestExecutor executor, String mountPath) {
        this(executor, mountPath, FACTORY);
    }

    public CompletionStage<Void> configUrls(VaultSecretsPKIConfigUrlsParams params) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).configUrls(this.mountPath, params)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<VaultSecretsPKIReadUrlsConfigResultData> readUrlsConfig() {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).readUrlsConfig(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKIConfigIssuersResultData> configIssuers(String defaultIssuer, Boolean defaultFollowsLatestIssuer) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).configIssuers(this.mountPath, defaultIssuer, defaultFollowsLatestIssuer)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKIReadIssuersConfigResultData> readIssuersConfig() {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).readIssuersConfig(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKIConfigKeysResultData> configKeys(String defaultKey) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).configKeys(this.mountPath, defaultKey)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKIReadKeysConfigResultData> readKeysConfig() {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).readKeysConfig(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKIConfigClusterResultData> configCluster(String path, String aiaPath) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).configCluster(this.mountPath, path, aiaPath)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKIReadClusterConfigResultData> readClusterConfig() {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).readClusterConfig(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<Void> configCrl(VaultSecretsPKIConfigCrlParams params) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).configCrl(this.mountPath, params)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<VaultSecretsPKIReadCrlConfigResultData> readCrlConfig() {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).readCrlConfig(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKIRotateCrlResultData> rotateCrl() {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).rotateCrl(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKIRotateDeltaCrlResultData> rotateDeltaCrl() {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).rotateDeltaCrl(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<List<String>> listRoles() {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).listRoles(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsPKIListRolesResultData)r.getData()).getKeys()).exceptionallyCompose(VaultCompletionStages.recoverNotFound(() -> List.of()));
    }

    public CompletionStage<VaultSecretsPKIReadRoleResultData> readRole(String roleName) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).readRole(this.mountPath, roleName)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<Void> updateRole(String roleName, VaultSecretsPKIUpdateRoleParams params) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).updateRole(this.mountPath, roleName, params)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> deleteRole(String roleName) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).deleteRole(this.mountPath, roleName)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<VaultSecretsPKIIssueResultData> issue(String roleName, VaultSecretsPKIIssueParams params) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).issue(this.mountPath, roleName, params)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKIIssueResultData> issue(String issuerRef, String roleName, VaultSecretsPKIIssueParams params) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).issue(this.mountPath, issuerRef, roleName, params)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKISignResultData> sign(String roleName, VaultSecretsPKISignParams params) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).sign(this.mountPath, roleName, params)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKISignResultData> sign(String issuerRef, String roleName, VaultSecretsPKISignParams params) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).sign(this.mountPath, issuerRef, roleName, params)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKISignResultData> signIntermediate(VaultSecretsPKISignIntermediateParams params) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).signIntermediate(this.mountPath, params)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKISignResultData> signIntermediate(String issuerRef, VaultSecretsPKISignIntermediateParams params) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).signIntermediate(this.mountPath, issuerRef, params)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKISignSelfIssuedResultData> signSelfIssued(String certificate, Boolean requireMatchingCertificateAlgorithms) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).signSelfIssued(this.mountPath, certificate, requireMatchingCertificateAlgorithms)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKISignSelfIssuedResultData> signSelfIssued(String issuerRef, String certificate, Boolean requireMatchingCertificateAlgorithms) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).signSelfIssued(this.mountPath, issuerRef, certificate, requireMatchingCertificateAlgorithms)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKISignResultData> signVerbatim(String roleName, VaultSecretsPKISignVerbatimParams params) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).signVerbatim(this.mountPath, roleName, params)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKISignResultData> signVerbatim(String issuerRef, String roleName, VaultSecretsPKISignVerbatimParams params) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).signVerbatim(this.mountPath, issuerRef, roleName, params)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKIRevokeResultData> revoke(VaultSecretsPKIRevokeParams params) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).revoke(this.mountPath, params)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKIRevokeWithKeyResultData> revokeWithKey(VaultSecretsPKIRevokeWithKeyParams params) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).revokeWithKey(this.mountPath, params)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<List<String>> listRevoked() {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).listRevoked(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsPKIListRevokedResultData)r.getData()).getKeys());
    }

    public CompletionStage<VaultSecretsPKIListIssuersResultData> listIssuers() {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).listIssuers(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData).exceptionallyCompose(VaultCompletionStages.recoverNotFound(() -> new VaultSecretsPKIListIssuersResultData().setKeys(List.of()).setKeyInfo(Map.of())));
    }

    public CompletionStage<VaultSecretsPKIReadIssuerCaCertResultData> readIssuerCaCert() {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).readIssuerCaCert(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKIReadIssuerCaCertResultData> readIssuerCaCert(String issuerRef) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).readIssuerCaCert(this.mountPath, issuerRef)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<String> readIssuerCaChain() {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).readIssuerCaChain(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsPKIReadIssuerCaChainResultData)r.getData()).getCaChain());
    }

    public CompletionStage<String> readIssuerCrl() {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).readIssuerCrl(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsPKIReadIssuerCrlResultData)r.getData()).getCertificate());
    }

    public CompletionStage<String> readIssuerCrl(String issuerRef) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).readIssuerCrl(this.mountPath, issuerRef)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsPKIReadIssuerCrlResultData)r.getData()).getCrl());
    }

    public CompletionStage<String> readIssuerDeltaCrl() {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).readIssuerDeltaCrl(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsPKIReadIssuerDeltaCrlResultData)r.getData()).getCertificate());
    }

    public CompletionStage<String> readIssuerDeltaCrl(String issuerRef) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).readIssuerDeltaCrl(this.mountPath, issuerRef)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsPKIReadIssuerDeltaCrlResultData)r.getData()).getCrl());
    }

    public CompletionStage<String> readIssuerUnifiedCrl() {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).readIssuerUnifiedCrl(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsPKIReadIssuerUnifiedCrlResultData)r.getData()).getCertificate());
    }

    public CompletionStage<String> readIssuerUnifiedCrl(String issuerRef) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).readIssuerUnifiedCrl(this.mountPath, issuerRef)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsPKIReadIssuerUnifiedCrlResultData)r.getData()).getCrl());
    }

    public CompletionStage<String> readIssuerUnifiedDeltaCrl() {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).readIssuerUnifiedDeltaCrl(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsPKIReadIssuerUnifiedDeltaCrlResultData)r.getData()).getCertificate());
    }

    public CompletionStage<String> readIssuerUnifiedDeltaCrl(String issuerRef) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).readIssuerUnifiedDeltaCrl(this.mountPath, issuerRef)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsPKIReadIssuerUnifiedDeltaCrlResultData)r.getData()).getCrl());
    }

    public CompletionStage<List<String>> listCertificates() {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).listCertificates(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsPKIListCertificatesResultData)r.getData()).getKeys());
    }

    public CompletionStage<VaultSecretsPKIReadCertificateResultData> readCertificate(String serialNumber) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).readCertificate(this.mountPath, serialNumber)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKIGenerateRootResultData> generateRoot(VaultSecretsPKIManageType type, VaultSecretsPKIGenerateRootParams params) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).generateRoot(this.mountPath, type, params)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKIGenerateRootResultData> generateIssuerRoot(VaultSecretsPKIManageType type, VaultSecretsPKIGenerateRootParams params) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).generateIssuerRoot(this.mountPath, type, params)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKIGenerateRootResultData> rotateRoot(VaultSecretsPKIManageType type, VaultSecretsPKIGenerateRootParams params) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).rotateRoot(this.mountPath, type, params)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKIGenerateCsrResultData> generateIntermediateCsr(VaultSecretsPKIManageType type, VaultSecretsPKIGenerateCsrParams params) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).generateIntermediateCsr(this.mountPath, type, params)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKIGenerateCsrResultData> generateIssuerIntermediateCsr(VaultSecretsPKIManageType type, VaultSecretsPKIGenerateCsrParams params) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).generateIssuerIntermediateCsr(this.mountPath, type, params)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKIGenerateCsrResultData> generateCrossSignCsr(VaultSecretsPKIGenerateCsrParams params) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).generateCrossSignCsr(this.mountPath, params)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKIImportResultData> setSignedIntermediate(String certificate) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).setSignedIntermediate(this.mountPath, certificate)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKIImportResultData> configCa(String pemBundle) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).configCa(this.mountPath, pemBundle)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKIImportResultData> importIssuerBundle(String pemBundle) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).importIssuerBundle(this.mountPath, pemBundle)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKIImportResultData> importIssuerCertificate(String pemBundle) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).importIssuerCertificate(this.mountPath, pemBundle)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKIRevokeIssuerResultData> revokeIssuer(String issuerRef) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).revokeIssuer(this.mountPath, issuerRef)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<Void> deleteIssuer(String issuerRef) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).deleteIssuer(this.mountPath, issuerRef)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<VaultSecretsPKIListKeysResultData> listKeys() {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).listKeys(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData).exceptionallyCompose(VaultCompletionStages.recoverNotFound(() -> new VaultSecretsPKIListKeysResultData().setKeys(List.of()).setKeyInfo(Map.of())));
    }

    public CompletionStage<VaultSecretsPKIKeyInfo> generateKey(VaultSecretsPKIManageType type, VaultSecretsPKIGenerateKeyParams params) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).generateKey(this.mountPath, type, params)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKIKeyInfo> importKey(String pemBundle, String keyName) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).importKey(this.mountPath, pemBundle, keyName)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKIKeyInfo> readKey(String keyRef) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).readKey(this.mountPath, keyRef)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSecretsPKIKeyInfo> updateKey(String keyRef, VaultSecretsPKIUpdateKeyParams params) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).updateKey(this.mountPath, keyRef, params)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<Void> deleteKey(String keyRef) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).deleteKey(this.mountPath, keyRef)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> deleteAll() {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).deleteAll(this.mountPath)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> tidy(VaultSecretsPKITidyParams params) {
        return this.executor.execute(((VaultSecretsPKIRequestFactory)this.factory).tidy(this.mountPath, params)).thenApply(VaultResponse::getResult);
    }
}

