/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.secrets.pki;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.quarkus.vault.client.common.VaultModel;

public enum VaultSecretsPKIKeyType implements VaultModel
{
    RSA("rsa"),
    EC("ec"),
    ED25519("ed25519");

    private final String value;

    private VaultSecretsPKIKeyType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    public static VaultSecretsPKIKeyType from(String value) {
        if (value == null) {
            return null;
        }
        for (VaultSecretsPKIKeyType v : VaultSecretsPKIKeyType.values()) {
            if (!v.value.equals(value)) continue;
            return v;
        }
        throw new IllegalArgumentException("Unknown value: " + value);
    }
}

