/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.secrets.pki;

import io.quarkus.vault.client.api.common.VaultRequestFactory;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIConfigCaParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIConfigCaResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIConfigClusterParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIConfigClusterResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIConfigCrlParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIConfigIssuersParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIConfigIssuersResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIConfigKeysParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIConfigKeysResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIConfigUrlsParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIGenerateCrossSignCsrResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIGenerateCsrParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIGenerateIntermediateCsrResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIGenerateIssuerIntermediateCsrResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIGenerateIssuerRootResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIGenerateKeyParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIGenerateKeyResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIGenerateRootParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIGenerateRootResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIImportIssuerBundleParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIImportIssuerBundleResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIImportIssuerCertificateParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIImportIssuerCertificateResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIImportKeyParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIImportKeyResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIIssueParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIIssueResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIListCertificatesResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIListIssuersResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIListKeysResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIListRevokedResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIListRolesResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIManageType;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIReadCertificateResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIReadClusterConfigResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIReadCrlConfigResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIReadIssuerCaCertResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIReadIssuerCaChainResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIReadIssuerCrlResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIReadIssuerDeltaCrlResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIReadIssuerUnifiedCrlResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIReadIssuerUnifiedDeltaCrlResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIReadIssuersConfigResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIReadKeyResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIReadKeysConfigResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIReadRoleResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIReadUrlsConfigResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIRevokeIssuerResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIRevokeParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIRevokeResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIRevokeWithKeyParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIRevokeWithKeyResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIRotateCrlResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIRotateDeltaCrlResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIRotateRootResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKISetSignedIntermediateParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKISetSignedIntermediateResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKISignIntermediateParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKISignIntermediateResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKISignParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKISignResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKISignSelfIssuedParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKISignSelfIssuedResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKISignVerbatimParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKISignVerbatimResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKITidyParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIUpdateKeyParams;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIUpdateKeyResult;
import io.quarkus.vault.client.api.secrets.pki.VaultSecretsPKIUpdateRoleParams;
import io.quarkus.vault.client.common.VaultLeasedResultExtractor;
import io.quarkus.vault.client.common.VaultRequest;

public class VaultSecretsPKIRequestFactory
extends VaultRequestFactory {
    public static final VaultSecretsPKIRequestFactory INSTANCE = new VaultSecretsPKIRequestFactory();

    public VaultSecretsPKIRequestFactory() {
        super("[SECRETS (pki)]");
    }

    public VaultRequest<Void> configUrls(String mountPath, VaultSecretsPKIConfigUrlsParams params) {
        return VaultRequest.post(this.getTraceOpName("Config Urls")).path(mountPath, "config", "urls").body(params).expectNoContentStatus().build();
    }

    public VaultRequest<VaultSecretsPKIReadUrlsConfigResult> readUrlsConfig(String mountPath) {
        return VaultRequest.get(this.getTraceOpName("Read Urls Config")).path(mountPath, "config", "urls").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIReadUrlsConfigResult.class));
    }

    public VaultRequest<VaultSecretsPKIConfigIssuersResult> configIssuers(String mountPath, String defaultIssuer, Boolean defaultFollowsLatestIssuer) {
        return VaultRequest.post(this.getTraceOpName("Config Issuers")).path(mountPath, "config", "issuers").body(new VaultSecretsPKIConfigIssuersParams().setDefaultIssuer(defaultIssuer).setDefaultFollowsLatestIssuer(defaultFollowsLatestIssuer)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIConfigIssuersResult.class));
    }

    public VaultRequest<VaultSecretsPKIReadIssuersConfigResult> readIssuersConfig(String mountPath) {
        return VaultRequest.get(this.getTraceOpName("Read Issuers Config")).path(mountPath, "config", "issuers").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIReadIssuersConfigResult.class));
    }

    public VaultRequest<VaultSecretsPKIConfigKeysResult> configKeys(String mountPath, String defaultKey) {
        return VaultRequest.post(this.getTraceOpName("Config Keys")).path(mountPath, "config", "keys").body(new VaultSecretsPKIConfigKeysParams().setDefaultKey(defaultKey)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIConfigKeysResult.class));
    }

    public VaultRequest<VaultSecretsPKIReadKeysConfigResult> readKeysConfig(String mountPath) {
        return VaultRequest.get(this.getTraceOpName("Read Keys Config")).path(mountPath, "config", "keys").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIReadKeysConfigResult.class));
    }

    public VaultRequest<VaultSecretsPKIConfigClusterResult> configCluster(String mountPath, String path, String aiaPath) {
        return VaultRequest.post(this.getTraceOpName("Config Cluster")).path(mountPath, "config", "cluster").body(new VaultSecretsPKIConfigClusterParams().setPath(path).setAiaPath(aiaPath)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIConfigClusterResult.class));
    }

    public VaultRequest<VaultSecretsPKIReadClusterConfigResult> readClusterConfig(String mountPath) {
        return VaultRequest.get(this.getTraceOpName("Read Cluster Config")).path(mountPath, "config", "cluster").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIReadClusterConfigResult.class));
    }

    public VaultRequest<Void> configCrl(String mountPath, VaultSecretsPKIConfigCrlParams params) {
        return VaultRequest.post(this.getTraceOpName("Config Crl")).path(mountPath, "config", "crl").body(params).expectNoContentStatus().build();
    }

    public VaultRequest<VaultSecretsPKIReadCrlConfigResult> readCrlConfig(String mountPath) {
        return VaultRequest.get(this.getTraceOpName("Read Crl Config")).path(mountPath, "config", "crl").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIReadCrlConfigResult.class));
    }

    public VaultRequest<VaultSecretsPKIRotateCrlResult> rotateCrl(String mountPath) {
        return VaultRequest.get(this.getTraceOpName("Rotate Crl")).path(mountPath, "crl", "rotate").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIRotateCrlResult.class));
    }

    public VaultRequest<VaultSecretsPKIRotateDeltaCrlResult> rotateDeltaCrl(String mountPath) {
        return VaultRequest.get(this.getTraceOpName("Rotate Delta Crl")).path(mountPath, "crl", "rotate").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIRotateDeltaCrlResult.class));
    }

    public VaultRequest<VaultSecretsPKIListRolesResult> listRoles(String mountPath) {
        return VaultRequest.list(this.getTraceOpName("List Roles")).path(mountPath, "roles").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIListRolesResult.class));
    }

    public VaultRequest<VaultSecretsPKIReadRoleResult> readRole(String mountPath, String roleName) {
        return VaultRequest.get(this.getTraceOpName("Read Role")).path(mountPath, "roles", roleName).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIReadRoleResult.class));
    }

    public VaultRequest<Void> updateRole(String mountPath, String roleName, VaultSecretsPKIUpdateRoleParams params) {
        return VaultRequest.post(this.getTraceOpName("Update Role")).path(mountPath, "roles", roleName).body(params).expectNoContentStatus().build();
    }

    public VaultRequest<Void> deleteRole(String mountPath, String roleName) {
        return VaultRequest.delete(this.getTraceOpName("Delete Role")).path(mountPath, "roles", roleName).expectNoContentStatus().build();
    }

    public VaultRequest<VaultSecretsPKIIssueResult> issue(String mountPath, String roleName, VaultSecretsPKIIssueParams params) {
        return VaultRequest.post(this.getTraceOpName("Issue")).path(mountPath, "issue", roleName).body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIIssueResult.class));
    }

    public VaultRequest<VaultSecretsPKIIssueResult> issue(String mountPath, String issuerRef, String roleName, VaultSecretsPKIIssueParams params) {
        return VaultRequest.post(this.getTraceOpName("Issue")).path(mountPath, "issuer", issuerRef, "issue", roleName).body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIIssueResult.class));
    }

    public VaultRequest<VaultSecretsPKISignResult> sign(String mountPath, String roleName, VaultSecretsPKISignParams params) {
        return VaultRequest.post(this.getTraceOpName("Sign")).path(mountPath, "sign", roleName).body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKISignResult.class));
    }

    public VaultRequest<VaultSecretsPKISignResult> sign(String mountPath, String issuerRef, String roleName, VaultSecretsPKISignParams params) {
        return VaultRequest.post(this.getTraceOpName("Sign")).path(mountPath, "issuer", issuerRef, "sign", roleName).body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKISignResult.class));
    }

    public VaultRequest<VaultSecretsPKISignIntermediateResult> signIntermediate(String mountPath, VaultSecretsPKISignIntermediateParams params) {
        return VaultRequest.post(this.getTraceOpName("Sign Intermediate")).path(mountPath, "root", "sign-intermediate").body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKISignIntermediateResult.class));
    }

    public VaultRequest<VaultSecretsPKISignIntermediateResult> signIntermediate(String mountPath, String issuerRef, VaultSecretsPKISignIntermediateParams params) {
        return VaultRequest.post(this.getTraceOpName("Sign Intermediate")).path(mountPath, "issuer", issuerRef, "sign-intermediate").body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKISignIntermediateResult.class));
    }

    public VaultRequest<VaultSecretsPKISignSelfIssuedResult> signSelfIssued(String mountPath, String certificate, Boolean requireMatchingCertificateAlgorithms) {
        return VaultRequest.post(this.getTraceOpName("Sign Self Issued")).path(mountPath, "root", "sign-self-issued").body(new VaultSecretsPKISignSelfIssuedParams().setCertificate(certificate).setRequireMatchingCertificateAlgorithms(requireMatchingCertificateAlgorithms)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKISignSelfIssuedResult.class));
    }

    public VaultRequest<VaultSecretsPKISignSelfIssuedResult> signSelfIssued(String mountPath, String issuerRef, String certificate, Boolean requireMatchingCertificateAlgorithms) {
        return VaultRequest.post(this.getTraceOpName("Sign Self Issued")).path(mountPath, "issuer", issuerRef, "sign-self-issued").body(new VaultSecretsPKISignSelfIssuedParams().setCertificate(certificate).setRequireMatchingCertificateAlgorithms(requireMatchingCertificateAlgorithms)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKISignSelfIssuedResult.class));
    }

    public VaultRequest<VaultSecretsPKISignVerbatimResult> signVerbatim(String mountPath, String roleName, VaultSecretsPKISignVerbatimParams params) {
        return VaultRequest.post(this.getTraceOpName("Sign Verbatim")).path(mountPath, "sign-verbatim", roleName).body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKISignVerbatimResult.class));
    }

    public VaultRequest<VaultSecretsPKISignVerbatimResult> signVerbatim(String mountPath, String issuerRef, String roleName, VaultSecretsPKISignVerbatimParams params) {
        return VaultRequest.post(this.getTraceOpName("Sign Verbatim")).path(mountPath, "issuer", issuerRef, "sign-verbatim", roleName).body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKISignVerbatimResult.class));
    }

    public VaultRequest<VaultSecretsPKIRevokeResult> revoke(String mountPath, VaultSecretsPKIRevokeParams params) {
        return VaultRequest.post(this.getTraceOpName("Revoke")).path(mountPath, "revoke").body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIRevokeResult.class));
    }

    public VaultRequest<VaultSecretsPKIRevokeWithKeyResult> revokeWithKey(String mountPath, VaultSecretsPKIRevokeWithKeyParams params) {
        return VaultRequest.post(this.getTraceOpName("Revoke With Key")).path(mountPath, "revoke-with-key").body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIRevokeWithKeyResult.class));
    }

    public VaultRequest<VaultSecretsPKIListRevokedResult> listRevoked(String mountPath) {
        return VaultRequest.list(this.getTraceOpName("List Revoked")).path(mountPath, "certs", "revoked").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIListRevokedResult.class));
    }

    public VaultRequest<VaultSecretsPKIListIssuersResult> listIssuers(String mountPath) {
        return VaultRequest.list(this.getTraceOpName("List Issuers")).path(mountPath, "issuers").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIListIssuersResult.class));
    }

    public VaultRequest<VaultSecretsPKIReadIssuerCaCertResult> readIssuerCaCert(String mountPath) {
        return VaultRequest.get(this.getTraceOpName("Read Issuer Ca Cert")).path(mountPath, "cert", "ca").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIReadIssuerCaCertResult.class));
    }

    public VaultRequest<VaultSecretsPKIReadIssuerCaCertResult> readIssuerCaCert(String mountPath, String issuerRef) {
        return VaultRequest.get(this.getTraceOpName("Read Issuer Ca Cert")).path(mountPath, "issuer", issuerRef, "json").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIReadIssuerCaCertResult.class));
    }

    public VaultRequest<VaultSecretsPKIReadIssuerCaChainResult> readIssuerCaChain(String mountPath) {
        return VaultRequest.get(this.getTraceOpName("Read Issuer Ca Chain")).path(mountPath, "cert", "ca_chain").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIReadIssuerCaChainResult.class));
    }

    public VaultRequest<VaultSecretsPKIReadIssuerCrlResult> readIssuerCrl(String mountPath) {
        return VaultRequest.get(this.getTraceOpName("Read Issuer Crl")).path(mountPath, "cert", "crl").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIReadIssuerCrlResult.class));
    }

    public VaultRequest<VaultSecretsPKIReadIssuerCrlResult> readIssuerCrl(String mountPath, String issuerRef) {
        return VaultRequest.get(this.getTraceOpName("Read Issuer Crl")).path(mountPath, "issuer", issuerRef, "crl").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIReadIssuerCrlResult.class));
    }

    public VaultRequest<VaultSecretsPKIReadIssuerDeltaCrlResult> readIssuerDeltaCrl(String mountPath) {
        return VaultRequest.get(this.getTraceOpName("Read Issuer Delta Crl")).path(mountPath, "cert", "delta-crl").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIReadIssuerDeltaCrlResult.class));
    }

    public VaultRequest<VaultSecretsPKIReadIssuerDeltaCrlResult> readIssuerDeltaCrl(String mountPath, String issuerRef) {
        return VaultRequest.get(this.getTraceOpName("Read Issuer Delta Crl")).path(mountPath, "issuer", issuerRef, "crl", "delta").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIReadIssuerDeltaCrlResult.class));
    }

    public VaultRequest<VaultSecretsPKIReadIssuerUnifiedCrlResult> readIssuerUnifiedCrl(String mountPath) {
        return VaultRequest.get(this.getTraceOpName("Read Issuer Unified Crl")).path(mountPath, "cert", "unified-crl").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIReadIssuerUnifiedCrlResult.class));
    }

    public VaultRequest<VaultSecretsPKIReadIssuerUnifiedCrlResult> readIssuerUnifiedCrl(String mountPath, String issuerRef) {
        return VaultRequest.get(this.getTraceOpName("Read Issuer Unified Crl")).path(mountPath, "issuer", issuerRef, "unified-crl").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIReadIssuerUnifiedCrlResult.class));
    }

    public VaultRequest<VaultSecretsPKIReadIssuerUnifiedDeltaCrlResult> readIssuerUnifiedDeltaCrl(String mountPath) {
        return VaultRequest.get(this.getTraceOpName("Read Issuer Unified Delta Crl")).path(mountPath, "cert", "unified-delta-crl").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIReadIssuerUnifiedDeltaCrlResult.class));
    }

    public VaultRequest<VaultSecretsPKIReadIssuerUnifiedDeltaCrlResult> readIssuerUnifiedDeltaCrl(String mountPath, String issuerRef) {
        return VaultRequest.get(this.getTraceOpName("Read Issuer Unified Delta Crl")).path(mountPath, "issuer", issuerRef, "unified-crl", "delta").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIReadIssuerUnifiedDeltaCrlResult.class));
    }

    public VaultRequest<VaultSecretsPKIListCertificatesResult> listCertificates(String mountPath) {
        return VaultRequest.list(this.getTraceOpName("List Certificates")).path(mountPath, "certs").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIListCertificatesResult.class));
    }

    public VaultRequest<VaultSecretsPKIReadCertificateResult> readCertificate(String mountPath, String serialNumber) {
        return VaultRequest.get(this.getTraceOpName("Read Certificate")).path(mountPath, "cert", serialNumber).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIReadCertificateResult.class));
    }

    public VaultRequest<VaultSecretsPKIGenerateRootResult> generateRoot(String mountPath, VaultSecretsPKIManageType type, VaultSecretsPKIGenerateRootParams params) {
        return VaultRequest.post(this.getTraceOpName("Generate Root")).path(mountPath, "root", "generate", type).body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIGenerateRootResult.class));
    }

    public VaultRequest<VaultSecretsPKIGenerateIssuerRootResult> generateIssuerRoot(String mountPath, VaultSecretsPKIManageType type, VaultSecretsPKIGenerateRootParams params) {
        return VaultRequest.post(this.getTraceOpName("Generate Issuer Root")).path(mountPath, "issuers", "generate", "root", type).body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIGenerateIssuerRootResult.class));
    }

    public VaultRequest<VaultSecretsPKIRotateRootResult> rotateRoot(String mountPath, VaultSecretsPKIManageType type, VaultSecretsPKIGenerateRootParams params) {
        return VaultRequest.post(this.getTraceOpName("Rotate Root")).path(mountPath, "root", "rotate", type).body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIRotateRootResult.class));
    }

    public VaultRequest<VaultSecretsPKIGenerateIntermediateCsrResult> generateIntermediateCsr(String mountPath, VaultSecretsPKIManageType type, VaultSecretsPKIGenerateCsrParams params) {
        return VaultRequest.post(this.getTraceOpName("Generate Intermediate Csr")).path(mountPath, "intermediate", "generate", type).body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIGenerateIntermediateCsrResult.class));
    }

    public VaultRequest<VaultSecretsPKIGenerateIssuerIntermediateCsrResult> generateIssuerIntermediateCsr(String mountPath, VaultSecretsPKIManageType type, VaultSecretsPKIGenerateCsrParams params) {
        return VaultRequest.post(this.getTraceOpName("Generate Issuer Intermediate Csr")).path(mountPath, "issuers", "generate", "intermediate", type).body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIGenerateIssuerIntermediateCsrResult.class));
    }

    public VaultRequest<VaultSecretsPKIGenerateCrossSignCsrResult> generateCrossSignCsr(String mountPath, VaultSecretsPKIGenerateCsrParams params) {
        return VaultRequest.post(this.getTraceOpName("Generate Cross Sign Csr")).path(mountPath, "intermediate", "cross-sign").body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIGenerateCrossSignCsrResult.class));
    }

    public VaultRequest<VaultSecretsPKISetSignedIntermediateResult> setSignedIntermediate(String mountPath, String certificate) {
        return VaultRequest.post(this.getTraceOpName("Set Signed Intermediate")).path(mountPath, "intermediate", "set-signed").body(new VaultSecretsPKISetSignedIntermediateParams().setCertificate(certificate)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKISetSignedIntermediateResult.class));
    }

    public VaultRequest<VaultSecretsPKIConfigCaResult> configCa(String mountPath, String pemBundle) {
        return VaultRequest.post(this.getTraceOpName("Config Ca")).path(mountPath, "config", "ca").body(new VaultSecretsPKIConfigCaParams().setPemBundle(pemBundle)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIConfigCaResult.class));
    }

    public VaultRequest<VaultSecretsPKIImportIssuerBundleResult> importIssuerBundle(String mountPath, String pemBundle) {
        return VaultRequest.post(this.getTraceOpName("Import Issuer Bundle")).path(mountPath, "issuers", "import", "bundle").body(new VaultSecretsPKIImportIssuerBundleParams().setPemBundle(pemBundle)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIImportIssuerBundleResult.class));
    }

    public VaultRequest<VaultSecretsPKIImportIssuerCertificateResult> importIssuerCertificate(String mountPath, String pemBundle) {
        return VaultRequest.post(this.getTraceOpName("Import Issuer Certificate")).path(mountPath, "issuers", "import", "cert").body(new VaultSecretsPKIImportIssuerCertificateParams().setPemBundle(pemBundle)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIImportIssuerCertificateResult.class));
    }

    public VaultRequest<VaultSecretsPKIRevokeIssuerResult> revokeIssuer(String mountPath, String issuerRef) {
        return VaultRequest.post(this.getTraceOpName("Revoke Issuer")).path(mountPath, "issuer", issuerRef, "revoke").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIRevokeIssuerResult.class));
    }

    public VaultRequest<Void> deleteIssuer(String mountPath, String issuerRef) {
        return VaultRequest.delete(this.getTraceOpName("Delete Issuer")).path(mountPath, "issuer", issuerRef).expectNoContentStatus().build();
    }

    public VaultRequest<VaultSecretsPKIListKeysResult> listKeys(String mountPath) {
        return VaultRequest.list(this.getTraceOpName("List Keys")).path(mountPath, "keys").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIListKeysResult.class));
    }

    public VaultRequest<VaultSecretsPKIGenerateKeyResult> generateKey(String mountPath, VaultSecretsPKIManageType type, VaultSecretsPKIGenerateKeyParams params) {
        return VaultRequest.post(this.getTraceOpName("Generate Key")).path(mountPath, "keys", "generate", type).body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIGenerateKeyResult.class));
    }

    public VaultRequest<VaultSecretsPKIImportKeyResult> importKey(String mountPath, String pemBundle, String keyName) {
        return VaultRequest.post(this.getTraceOpName("Import Key")).path(mountPath, "keys", "import").body(new VaultSecretsPKIImportKeyParams().setPemBundle(pemBundle).setKeyName(keyName)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIImportKeyResult.class));
    }

    public VaultRequest<VaultSecretsPKIReadKeyResult> readKey(String mountPath, String keyRef) {
        return VaultRequest.get(this.getTraceOpName("Read Key")).path(mountPath, "key", keyRef).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIReadKeyResult.class));
    }

    public VaultRequest<VaultSecretsPKIUpdateKeyResult> updateKey(String mountPath, String keyRef, VaultSecretsPKIUpdateKeyParams params) {
        return VaultRequest.post(this.getTraceOpName("Update Key")).path(mountPath, "key", keyRef).body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsPKIUpdateKeyResult.class));
    }

    public VaultRequest<Void> deleteKey(String mountPath, String keyRef) {
        return VaultRequest.delete(this.getTraceOpName("Delete Key")).path(mountPath, "key", keyRef).expectNoContentStatus().build();
    }

    public VaultRequest<Void> deleteAll(String mountPath) {
        return VaultRequest.delete(this.getTraceOpName("Delete All")).path(mountPath, "root").expectNoContentStatus().build();
    }

    public VaultRequest<Void> tidy(String mountPath, VaultSecretsPKITidyParams params) {
        return VaultRequest.post(this.getTraceOpName("Tidy")).path(mountPath, "tidy").body(params).expectOkOrAcceptedStatus().build();
    }
}

