/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.secrets.transit;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.quarkus.vault.client.common.VaultModel;

public enum VaultSecretsTransitHashFunction implements VaultModel
{
    SHA1("SHA1"),
    SHA256("SHA256"),
    SHA384("SHA384"),
    SHA512("SHA512");

    private final String value;

    private VaultSecretsTransitHashFunction(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    public static VaultSecretsTransitHashFunction from(String value) {
        if (value == null) {
            return null;
        }
        for (VaultSecretsTransitHashFunction v : VaultSecretsTransitHashFunction.values()) {
            if (!v.value.equals(value)) continue;
            return v;
        }
        throw new IllegalArgumentException("Unknown value: " + value);
    }
}

