/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.secrets.transit;

import io.quarkus.vault.client.api.common.VaultFormat;
import io.quarkus.vault.client.api.common.VaultHashAlgorithm;
import io.quarkus.vault.client.api.common.VaultRandomSource;
import io.quarkus.vault.client.api.common.VaultRequestFactory;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitBackupKeyResult;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitCreateKeyParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitCreateKeyResult;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitDecryptBatchParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitDecryptBatchResult;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitDecryptParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitDecryptResult;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitEncryptBatchParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitEncryptBatchResult;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitEncryptParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitEncryptResult;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitExportKeyResult;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitExportKeyType;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitGetWrappingKeyResult;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitHashParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitHashResult;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitHmacBatchParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitHmacBatchResult;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitHmacParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitHmacResult;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitImportKeyParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitImportKeyVersionParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitListKeysResult;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitRandomParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitRandomResult;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitReadCacheConfigResult;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitReadKeyResult;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitReadKeysConfigResult;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitRestoreKeyParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitRewrapBatchParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitRewrapBatchResult;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitRewrapParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitRewrapResult;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitRotateKeyParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitSecureExportKeyResult;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitSignBatchParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitSignBatchResult;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitSignCsrParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitSignCsrResult;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitSignParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitSignResult;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitTrimKeyParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitUpdateCacheConfigParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitUpdateKeyParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitUpdateKeysConfigParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitVerifyBatchParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitVerifyBatchResult;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitVerifyParams;
import io.quarkus.vault.client.api.secrets.transit.VaultSecretsTransitVerifyResult;
import io.quarkus.vault.client.common.VaultLeasedResultExtractor;
import io.quarkus.vault.client.common.VaultRequest;

public class VaultSecretsTransitRequestFactory
extends VaultRequestFactory {
    public static final VaultSecretsTransitRequestFactory INSTANCE = new VaultSecretsTransitRequestFactory();

    public VaultSecretsTransitRequestFactory() {
        super("[SECRETS (transit)]");
    }

    public VaultRequest<VaultSecretsTransitCreateKeyResult> createKey(String mountPath, String name, VaultSecretsTransitCreateKeyParams params) {
        return VaultRequest.post(this.getTraceOpName("Create Key")).path(mountPath, "keys", name).body(params).expectOkOrNoContentStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTransitCreateKeyResult.class));
    }

    public VaultRequest<Void> importKey(String mountPath, String name, VaultSecretsTransitImportKeyParams params) {
        return VaultRequest.post(this.getTraceOpName("Import Key")).path(mountPath, "keys", name, "import").body(params).expectNoContentStatus().build();
    }

    public VaultRequest<Void> importKeyVersion(String mountPath, String name, VaultSecretsTransitImportKeyVersionParams params) {
        return VaultRequest.post(this.getTraceOpName("Import Key Version")).path(mountPath, "keys", name, "import_version").body(params).expectNoContentStatus().build();
    }

    public VaultRequest<VaultSecretsTransitGetWrappingKeyResult> getWrappingKey(String mountPath) {
        return VaultRequest.get(this.getTraceOpName("Get Wrapping Key")).path(mountPath, "wrapping_key").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTransitGetWrappingKeyResult.class));
    }

    public VaultRequest<VaultSecretsTransitListKeysResult> listKeys(String mountPath) {
        return VaultRequest.list(this.getTraceOpName("List Keys")).path(mountPath, "keys").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTransitListKeysResult.class));
    }

    public VaultRequest<VaultSecretsTransitReadKeyResult> readKey(String mountPath, String name) {
        return VaultRequest.get(this.getTraceOpName("Read Key")).path(mountPath, "keys", name).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTransitReadKeyResult.class));
    }

    public VaultRequest<Void> deleteKey(String mountPath, String name) {
        return VaultRequest.delete(this.getTraceOpName("Delete Key")).path(mountPath, "keys", name).expectNoContentStatus().build();
    }

    public VaultRequest<Void> updateKey(String mountPath, String name, VaultSecretsTransitUpdateKeyParams params) {
        return VaultRequest.post(this.getTraceOpName("Update Key")).path(mountPath, "keys", name, "config").body(params).expectNoContentStatus().build();
    }

    public VaultRequest<Void> rotateKey(String mountPath, String name, VaultSecretsTransitRotateKeyParams params) {
        return VaultRequest.post(this.getTraceOpName("Rotate Key")).path(mountPath, "keys", name, "rotate").body(params).expectNoContentStatus().build();
    }

    public VaultRequest<VaultSecretsTransitSignCsrResult> signCsr(String mountPath, String name, VaultSecretsTransitSignCsrParams params) {
        return VaultRequest.post(this.getTraceOpName("Sign Csr")).path(mountPath, "keys", name, "csr").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTransitSignCsrResult.class));
    }

    public VaultRequest<Void> setCertificateChain(String mountPath, String name, String version, String certificateChain) {
        return VaultRequest.post(this.getTraceOpName("Set Certificate Chain")).path(mountPath, "keys", name, "set-certificate").expectNoContentStatus().build();
    }

    public VaultRequest<VaultSecretsTransitSecureExportKeyResult> secureExportKey(String mountPath, String destination, String source, String version) {
        return VaultRequest.get(this.getTraceOpName("Secure Export Key")).path(mountPath, "byok-export", destination, source, version).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTransitSecureExportKeyResult.class));
    }

    public VaultRequest<VaultSecretsTransitExportKeyResult> exportKey(String mountPath, VaultSecretsTransitExportKeyType keyType, String name, String version) {
        return VaultRequest.get(this.getTraceOpName("Export Key")).path(mountPath, "export", keyType, name, version).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTransitExportKeyResult.class));
    }

    public VaultRequest<VaultSecretsTransitReadKeysConfigResult> readKeysConfig(String mountPath) {
        return VaultRequest.get(this.getTraceOpName("Read Keys Config")).path(mountPath, "config", "keys").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTransitReadKeysConfigResult.class));
    }

    public VaultRequest<Void> updateKeysConfig(String mountPath, VaultSecretsTransitUpdateKeysConfigParams params) {
        return VaultRequest.post(this.getTraceOpName("Update Keys Config")).path(mountPath, "config", "keys").body(params).expectNoContentStatus().build();
    }

    public VaultRequest<VaultSecretsTransitEncryptResult> encrypt(String mountPath, String name, VaultSecretsTransitEncryptParams params) {
        return VaultRequest.post(this.getTraceOpName("Encrypt")).path(mountPath, "encrypt", name).body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTransitEncryptResult.class));
    }

    public VaultRequest<VaultSecretsTransitEncryptBatchResult> encryptBatch(String mountPath, String name, VaultSecretsTransitEncryptBatchParams params) {
        return VaultRequest.post(this.getTraceOpName("Encrypt Batch")).path(mountPath, "encrypt", name).body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTransitEncryptBatchResult.class));
    }

    public VaultRequest<VaultSecretsTransitDecryptResult> decrypt(String mountPath, String name, VaultSecretsTransitDecryptParams params) {
        return VaultRequest.post(this.getTraceOpName("Decrypt")).path(mountPath, "decrypt", name).body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTransitDecryptResult.class));
    }

    public VaultRequest<VaultSecretsTransitDecryptBatchResult> decryptBatch(String mountPath, String name, VaultSecretsTransitDecryptBatchParams params) {
        return VaultRequest.post(this.getTraceOpName("Decrypt Batch")).path(mountPath, "decrypt", name).body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTransitDecryptBatchResult.class));
    }

    public VaultRequest<VaultSecretsTransitRewrapResult> rewrap(String mountPath, String name, VaultSecretsTransitRewrapParams params) {
        return VaultRequest.post(this.getTraceOpName("Rewrap")).path(mountPath, "rewrap", name).body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTransitRewrapResult.class));
    }

    public VaultRequest<VaultSecretsTransitRewrapBatchResult> rewrapBatch(String mountPath, String name, VaultSecretsTransitRewrapBatchParams params) {
        return VaultRequest.post(this.getTraceOpName("Rewrap Batch")).path(mountPath, "rewrap", name).body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTransitRewrapBatchResult.class));
    }

    public VaultRequest<VaultSecretsTransitRandomResult> random(String mountPath, Integer bytes, VaultRandomSource source, VaultFormat format) {
        return VaultRequest.post(this.getTraceOpName("Random")).path(mountPath, "random", source, bytes).body(new VaultSecretsTransitRandomParams().setFormat(format)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTransitRandomResult.class));
    }

    public VaultRequest<VaultSecretsTransitHashResult> hash(String mountPath, VaultHashAlgorithm algorithm, byte[] input, VaultFormat format) {
        return VaultRequest.post(this.getTraceOpName("Hash")).path(mountPath, "hash", algorithm).body(new VaultSecretsTransitHashParams().setInput(input).setFormat(format)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTransitHashResult.class));
    }

    public VaultRequest<VaultSecretsTransitHmacResult> hmac(String mountPath, String name, VaultHashAlgorithm algorithm, byte[] input, Integer keyVersion) {
        return VaultRequest.post(this.getTraceOpName("Hmac")).path(mountPath, "hmac", name).body(new VaultSecretsTransitHmacParams().setAlgorithm(algorithm).setInput(input).setKeyVersion(keyVersion)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTransitHmacResult.class));
    }

    public VaultRequest<VaultSecretsTransitHmacBatchResult> hmacBatch(String mountPath, String name, VaultSecretsTransitHmacBatchParams params) {
        return VaultRequest.post(this.getTraceOpName("Hmac Batch")).path(mountPath, "hmac", name).body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTransitHmacBatchResult.class));
    }

    public VaultRequest<VaultSecretsTransitSignResult> sign(String mountPath, String name, VaultSecretsTransitSignParams params) {
        return VaultRequest.post(this.getTraceOpName("Sign")).path(mountPath, "sign", name).body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTransitSignResult.class));
    }

    public VaultRequest<VaultSecretsTransitSignBatchResult> signBatch(String mountPath, String name, VaultSecretsTransitSignBatchParams params) {
        return VaultRequest.post(this.getTraceOpName("Sign Batch")).path(mountPath, "sign", name).body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTransitSignBatchResult.class));
    }

    public VaultRequest<VaultSecretsTransitVerifyResult> verify(String mountPath, String name, VaultSecretsTransitVerifyParams params) {
        return VaultRequest.post(this.getTraceOpName("Verify")).path(mountPath, "verify", name).body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTransitVerifyResult.class));
    }

    public VaultRequest<VaultSecretsTransitVerifyBatchResult> verifyBatch(String mountPath, String name, VaultSecretsTransitVerifyBatchParams params) {
        return VaultRequest.post(this.getTraceOpName("Verify Batch")).path(mountPath, "verify", name).body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTransitVerifyBatchResult.class));
    }

    public VaultRequest<VaultSecretsTransitBackupKeyResult> backupKey(String mountPath, String name) {
        return VaultRequest.get(this.getTraceOpName("Backup Key")).path(mountPath, "backup", name).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTransitBackupKeyResult.class));
    }

    public VaultRequest<Void> restoreKey(String mountPath, String name, String backup, Boolean force) {
        return VaultRequest.post(this.getTraceOpName("Restore Key")).path(mountPath, "restore", name).body(new VaultSecretsTransitRestoreKeyParams().setBackup(backup).setForce(force)).expectNoContentStatus().build();
    }

    public VaultRequest<Void> trimKey(String mountPath, String name, Integer minAvailableVersion) {
        return VaultRequest.post(this.getTraceOpName("Trim Key")).path(mountPath, "keys", name, "trim").body(new VaultSecretsTransitTrimKeyParams().setMinAvailableVersion(minAvailableVersion)).expectNoContentStatus().build();
    }

    public VaultRequest<Void> updateCacheConfig(String mountPath, Integer size) {
        return VaultRequest.post(this.getTraceOpName("Update Cache Config")).path(mountPath, "cache-config").body(new VaultSecretsTransitUpdateCacheConfigParams().setSize(size)).expectNoContentStatus().build();
    }

    public VaultRequest<VaultSecretsTransitReadCacheConfigResult> readCacheConfig(String mountPath) {
        return VaultRequest.get(this.getTraceOpName("Read Cache Config")).path(mountPath, "cache-config").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTransitReadCacheConfigResult.class));
    }
}

