/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.auth;

import io.quarkus.vault.client.VaultClientException;
import io.quarkus.vault.client.api.auth.token.VaultAuthToken;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenRenewSelfAuthResult;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenRenewSelfResult;
import io.quarkus.vault.client.auth.VaultAuthRequest;
import io.quarkus.vault.client.auth.VaultToken;
import io.quarkus.vault.client.auth.VaultTokenProvider;
import io.quarkus.vault.client.common.VaultRequest;
import io.quarkus.vault.client.common.VaultResponse;
import io.quarkus.vault.client.logging.LogConfidentialityLevel;
import io.quarkus.vault.client.util.OptionalCompletionStages;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;

public class VaultCachingTokenProvider
implements VaultTokenProvider {
    public static Duration DEFAULT_RENEW_GRACE_PERIOD = Duration.ofSeconds(30L);
    private static final Logger log = Logger.getLogger(VaultCachingTokenProvider.class.getName());
    private final VaultTokenProvider delegate;
    private final Duration renewGracePeriod;
    private final AtomicReference<VaultToken> cachedToken = new AtomicReference<Object>(null);

    public VaultCachingTokenProvider(VaultTokenProvider delegate, Duration renewGracePeriod) {
        this.delegate = delegate;
        this.renewGracePeriod = renewGracePeriod;
    }

    @Override
    public CompletionStage<VaultToken> apply(VaultAuthRequest authRequest) {
        Optional<VaultToken> cachedToken = Optional.ofNullable(this.cachedToken.get()).map(token -> {
            if (token.isExpired()) {
                log.fine("cached token " + token.getClientToken() + " has expired");
                return null;
            }
            log.fine("using cached token " + token.getClientToken() + " (expires at " + token.getExpiresAt() + ")");
            return token;
        });
        return CompletableFuture.completedStage(cachedToken).thenCompose(OptionalCompletionStages.flatMapPresent(token -> {
            if (token.shouldExtend(this.renewGracePeriod)) {
                return this.extend(authRequest, token.getClientToken());
            }
            return CompletableFuture.completedStage(token);
        })).thenCompose(OptionalCompletionStages.flatMapEmptyGet(() -> this.request(authRequest))).thenApply(vaultToken -> {
            this.cachedToken.set(vaultToken.cached());
            return vaultToken;
        });
    }

    @Override
    public void invalidateCache() {
        this.cachedToken.set(null);
    }

    @Override
    public VaultTokenProvider caching(Duration renewGracePeriod) {
        return this;
    }

    public CompletionStage<VaultToken> request(VaultAuthRequest authRequest) {
        LogConfidentialityLevel logLevel = authRequest.getRequest().getLogConfidentialityLevel();
        return ((CompletionStage)this.delegate.apply(authRequest)).thenApply(vaultToken -> {
            this.sanityCheck((VaultToken)vaultToken);
            log.fine("created new login token: " + vaultToken.getConfidentialInfo(logLevel));
            return vaultToken;
        });
    }

    public CompletionStage<VaultToken> extend(VaultAuthRequest authRequest, String clientToken) {
        LogConfidentialityLevel logLevel = authRequest.getRequest().getLogConfidentialityLevel();
        VaultRequest<VaultAuthTokenRenewSelfResult> request = VaultAuthToken.FACTORY.renewSelf(null).builder().token(clientToken).rebuild();
        return authRequest.getExecutor().execute(request).thenApply(VaultResponse::getResult).thenApply(res -> {
            VaultAuthTokenRenewSelfAuthResult auth = (VaultAuthTokenRenewSelfAuthResult)res.getAuth();
            VaultToken vaultToken = VaultToken.from(auth.getClientToken(), auth.isRenewable(), auth.getLeaseDuration(), authRequest.getInstantSource());
            this.sanityCheck(vaultToken);
            log.fine("extended login token: " + vaultToken.getConfidentialInfo(logLevel));
            return vaultToken;
        }).exceptionallyCompose(e -> {
            VaultClientException ve;
            if (e instanceof CompletionException) {
                e = e.getCause();
            }
            if (e instanceof VaultClientException && ((ve = (VaultClientException)e).isPermissionDenied() || ve.hasErrorContaining("lease is not renewable"))) {
                log.fine("login token " + clientToken + " has become invalid");
                return CompletableFuture.completedStage(null);
            }
            return CompletableFuture.failedStage(e);
        });
    }

    private void sanityCheck(VaultToken vaultToken) {
        vaultToken.leaseDurationSanityCheck("auth", this.renewGracePeriod);
    }
}

