/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.auth;

import java.time.Duration;
import java.time.Instant;
import java.time.InstantSource;
import java.util.logging.Logger;

public abstract class VaultTimeLimited {
    private static final Logger log = Logger.getLogger(VaultTimeLimited.class.getName());
    InstantSource instantSource;
    Instant created;
    public boolean renewable;
    public Duration leaseDuration;

    public VaultTimeLimited(boolean renewable, Duration leaseDuration, InstantSource instantSource) {
        this.instantSource = instantSource;
        this.created = instantSource.instant();
        this.renewable = renewable;
        this.leaseDuration = leaseDuration;
    }

    public boolean isExpired() {
        return this.instantSource.instant().isAfter(this.getExpiresAt());
    }

    public boolean isExpiringWithin(Duration gracePeriod) {
        return this.instantSource.instant().plus(gracePeriod).isAfter(this.getExpiresAt());
    }

    public boolean shouldExtend(Duration gracePeriod) {
        return !this.isExpired() && this.renewable && this.isExpiringWithin(gracePeriod);
    }

    public Instant getExpiresAt() {
        return this.created.plus(this.leaseDuration);
    }

    public String info() {
        return "renewable: " + this.renewable + ", leaseDuration: " + this.leaseDuration + ", valid_until: " + this.getExpiresAt();
    }

    public void leaseDurationSanityCheck(String nickname, Duration gracePeriod) {
        if (this.leaseDuration.compareTo(gracePeriod) < 0) {
            log.warning(nickname + " lease duration " + this.leaseDuration + "s is smaller than the renew grace period " + gracePeriod.getSeconds() + "s");
        }
    }
}

