/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.common;

import io.quarkus.vault.client.VaultClientException;
import io.quarkus.vault.client.common.VaultResultExtractor;
import io.quarkus.vault.client.common.VaultVoidResultExtractor;
import io.quarkus.vault.client.json.JsonMapping;
import io.quarkus.vault.client.logging.LogConfidentialityLevel;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class VaultRequest<T> {
    public static List<Integer> OK_STATUS = List.of(Integer.valueOf(200));
    public static List<Integer> NO_CONTENT_STATUS = List.of(Integer.valueOf(204));
    public static List<Integer> ACCEPTED_STATUS = List.of(Integer.valueOf(202));
    public static List<Integer> OK_OR_ACCEPTED_STATUS = List.of(Integer.valueOf(200), Integer.valueOf(202));
    public static List<Integer> OK_OR_NO_CONTENT_STATUS = List.of(Integer.valueOf(200), Integer.valueOf(204));
    private final URL baseUrl;
    private final String apiVersion;
    private final String operation;
    private final Method method;
    private final String path;
    private final Optional<String> token;
    private final Optional<String> namespace;
    private final Optional<Duration> wrapTTL;
    private final Map<String, String> headers;
    private final Map<String, String> queryParams;
    private final Object body;
    private final VaultResultExtractor<T> resultExtractor;
    private final List<Integer> expectedStatusCodes;
    private final Duration timeout;
    private final LogConfidentialityLevel logConfidentialityLevel;

    private VaultRequest(Builder<?> builder) {
        this.baseUrl = builder.baseUrl;
        this.apiVersion = builder.apiVersion;
        this.operation = builder.operation;
        this.method = builder.method;
        this.path = builder.path;
        this.token = builder.token;
        this.namespace = builder.namespace;
        this.wrapTTL = builder.wrapTTL;
        this.headers = builder.headers;
        this.queryParams = builder.queryParams;
        this.body = builder.body;
        this.expectedStatusCodes = builder.expectedStatusCodes;
        this.timeout = builder.timeout;
        this.logConfidentialityLevel = builder.logConfidentialityLevel;
        this.resultExtractor = builder.resultExtractor;
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getOperation() {
        return this.operation;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public boolean hasToken() {
        return this.token != null;
    }

    public Optional<String> getToken() {
        return this.token != null ? this.token : Optional.empty();
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public Optional<String> getNamespace() {
        return this.namespace != null ? this.namespace : Optional.empty();
    }

    public boolean hasWrapTTL() {
        return this.wrapTTL != null;
    }

    public Optional<Duration> getWrapTTL() {
        return this.wrapTTL != null ? this.wrapTTL : Optional.empty();
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public boolean hasBody() {
        return this.body != null;
    }

    public Optional<Object> getBody() {
        return Optional.ofNullable(this.body);
    }

    public Optional<String> getSerializedBody() {
        if (this.body == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(JsonMapping.mapper.writeValueAsString(this.body));
        }
        catch (Exception e) {
            throw new VaultClientException(this, null, List.of("Failed to serialize request body"), null);
        }
    }

    public VaultResultExtractor<T> getResultExtractor() {
        return this.resultExtractor;
    }

    public List<Integer> getExpectedStatusCodes() {
        return this.expectedStatusCodes;
    }

    public LogConfidentialityLevel getLogConfidentialityLevel() {
        return this.logConfidentialityLevel;
    }

    public URL getUrl() {
        if (this.baseUrl == null) {
            throw new IllegalStateException("baseUrl is not set");
        }
        Object fullPath = VaultRequest.joinPath(this.baseUrl.getPath(), this.apiVersion, this.path);
        if (!this.queryParams.isEmpty()) {
            fullPath = (String)fullPath + "?" + this.getQueryParamsString();
        }
        try {
            return new URL(this.baseUrl, (String)fullPath);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Invalid URL for Vault request", e);
        }
    }

    public Map<String, String> getHTTPHeaders() {
        HashMap<String, String> allHeaders = new HashMap<String, String>(this.headers);
        this.getToken().ifPresent(token -> allHeaders.put("X-Vault-Token", (String)token));
        this.getNamespace().ifPresent(namespace -> allHeaders.put("X-Vault-Namespace", (String)namespace));
        this.getWrapTTL().ifPresent(wrapTTL -> allHeaders.put("X-Vault-Wrap-TTL", String.valueOf(wrapTTL.toSeconds())));
        return allHeaders;
    }

    public URI getUri() {
        return URI.create(this.getUrl().toString());
    }

    private String getQueryParamsString() {
        return this.queryParams.entrySet().stream().map(e -> {
            String key = URLEncoder.encode((String)e.getKey(), StandardCharsets.UTF_8);
            String value = (String)e.getValue();
            if (value == null) {
                return key;
            }
            return key + "=" + URLEncoder.encode(value, StandardCharsets.UTF_8);
        }).collect(Collectors.joining("&"));
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public Builder<T> builder() {
        Builder builder = new Builder(this.operation, this.method);
        builder.baseUrl = this.baseUrl;
        builder.apiVersion = this.apiVersion;
        builder.operation = this.operation;
        builder.method = this.method;
        builder.path = this.path;
        builder.token = this.token;
        builder.namespace = this.namespace;
        builder.wrapTTL = this.wrapTTL;
        builder.queryParams = this.queryParams;
        builder.headers = this.headers;
        builder.body = this.body;
        builder.expectedStatusCodes = this.expectedStatusCodes;
        builder.timeout = this.timeout;
        builder.resultExtractor = this.resultExtractor;
        builder.logConfidentialityLevel = this.logConfidentialityLevel;
        return builder;
    }

    public static <T> Builder<T> request(String operation, Method method) {
        return new Builder(operation, method);
    }

    public static <T> Builder<T> get(String operation) {
        return VaultRequest.request(operation, Method.GET);
    }

    public static <T> Builder<T> post(String operation) {
        return VaultRequest.request(operation, Method.POST);
    }

    public static <T> Builder<T> put(String operation) {
        return VaultRequest.request(operation, Method.PUT);
    }

    public static <T> Builder<T> patch(String operation) {
        return VaultRequest.request(operation, Method.PATCH);
    }

    public static <T> Builder<T> delete(String operation) {
        return VaultRequest.request(operation, Method.DELETE);
    }

    public static <T> Builder<T> list(String operation) {
        return VaultRequest.request(operation, Method.LIST);
    }

    public static <T> Builder<T> head(String operation) {
        return VaultRequest.request(operation, Method.HEAD);
    }

    private static String joinPath(Object ... pathSegments) {
        return Arrays.stream(pathSegments).filter(Objects::nonNull).map(s -> (String)JsonMapping.mapper.convertValue(s, String.class)).map(s -> s.startsWith("/") ? s.substring(1) : s).map(s -> s.endsWith("/") ? s.substring(0, s.length() - 1) : s).filter(s -> !s.isEmpty()).collect(Collectors.joining("/"));
    }

    public static class Builder<T> {
        private URL baseUrl;
        private String apiVersion = "v1";
        private String operation;
        private Method method;
        private String path;
        private Optional<String> token;
        private Optional<String> namespace;
        private Optional<Duration> wrapTTL;
        private Map<String, String> queryParams = new LinkedHashMap<String, String>();
        private Map<String, String> headers = new LinkedHashMap<String, String>();
        private Object body;
        private VaultResultExtractor<?> resultExtractor;
        private List<Integer> expectedStatusCodes = List.of();
        private Duration timeout = Duration.ofSeconds(30L);
        private LogConfidentialityLevel logConfidentialityLevel = LogConfidentialityLevel.HIGH;

        private Builder(String operation, Method method) {
            this.operation = operation;
            this.method = method;
        }

        public Builder<T> baseUrl(URL baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder<T> apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public Builder<T> path(Object ... pathSegments) {
            this.path = VaultRequest.joinPath(pathSegments);
            return this;
        }

        public final Builder<T> pathChoice(boolean selector, Object[] truePathSegments, Object[] falsePathSegments) {
            return this.path(selector ? truePathSegments : falsePathSegments);
        }

        public final Builder<T> pathChoice(Object selector, Map<Object, Object[]> options) {
            for (Map.Entry<Object, Object[]> option : options.entrySet()) {
                if (!option.getKey().equals(selector)) continue;
                return this.path(option.getValue());
            }
            throw new IllegalArgumentException("No path choice for selector " + selector);
        }

        public Builder<T> token(String token) {
            this.token = Optional.ofNullable(token);
            return this;
        }

        public Builder<T> noToken() {
            return this.token(null);
        }

        public Builder<T> wrapTTL(Duration ttl) {
            this.wrapTTL = Optional.of(ttl);
            return this;
        }

        public Builder<T> namespace(String namespace) {
            this.namespace = Optional.of(namespace);
            return this;
        }

        public Builder<T> noNamespace() {
            this.namespace = Optional.empty();
            return this;
        }

        public Builder<T> queryParam(String key, Object value) {
            Objects.requireNonNull(key, "key is required");
            String valueStr = (String)JsonMapping.mapper.convertValue(value, String.class);
            this.queryParams.put(key, valueStr);
            return this;
        }

        public Builder<T> queryParam(boolean condition, String key, Object value) {
            if (condition) {
                this.queryParam(key, value);
            }
            return this;
        }

        public Builder<T> header(String key, Object value) {
            Objects.requireNonNull(key, "key is required");
            Objects.requireNonNull(value, "value is required");
            String valueStr = (String)JsonMapping.mapper.convertValue(value, String.class);
            this.headers.put(key, valueStr);
            return this;
        }

        public Builder<T> header(boolean condition, String key, Object value) {
            if (condition) {
                this.header(key, value);
            }
            return this;
        }

        public Builder<T> body(Object body) {
            this.body = body;
            return this;
        }

        public Builder<T> expectedStatusCodes(List<Integer> expectedStatusCodes) {
            this.expectedStatusCodes = expectedStatusCodes;
            return this;
        }

        public Builder<T> expectOkStatus() {
            return this.expectedStatusCodes(OK_STATUS);
        }

        public Builder<T> expectNoContentStatus() {
            return this.expectedStatusCodes(NO_CONTENT_STATUS);
        }

        public Builder<T> expectAcceptedStatus() {
            return this.expectedStatusCodes(ACCEPTED_STATUS);
        }

        public Builder<T> expectOkOrAcceptedStatus() {
            return this.expectedStatusCodes(OK_OR_ACCEPTED_STATUS);
        }

        public Builder<T> expectOkOrNoContentStatus() {
            return this.expectedStatusCodes(OK_OR_NO_CONTENT_STATUS);
        }

        public Builder<T> expectAnyStatus() {
            return this.expectedStatusCodes(List.of());
        }

        public Builder<T> timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder<T> logConfidentialityLevel(LogConfidentialityLevel logConfidentialityLevel) {
            this.logConfidentialityLevel = logConfidentialityLevel;
            return this;
        }

        public VaultRequest<T> rebuild() {
            return new VaultRequest(this);
        }

        public <U> VaultRequest<U> build(VaultResultExtractor<U> resultExtractor) {
            this.resultExtractor = resultExtractor;
            return new VaultRequest(this);
        }

        public VaultRequest<Void> build() {
            return this.build(VaultVoidResultExtractor.INSTANCE);
        }
    }

    public static enum Method {
        GET,
        PUT,
        POST,
        PATCH,
        DELETE,
        HEAD,
        LIST;

    }
}

