/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.quarkus.vault.client.VaultClientException;
import io.quarkus.vault.client.common.VaultErrorResponse;
import io.quarkus.vault.client.common.VaultRequest;
import io.quarkus.vault.client.common.VaultRequestExecutor;
import io.quarkus.vault.client.common.VaultResponse;
import io.quarkus.vault.client.json.JsonMapping;
import java.net.ConnectException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public abstract class VaultHttpClient
implements VaultRequestExecutor,
AutoCloseable {
    public static final String X_VAULT_TOKEN = "X-Vault-Token";
    public static final String X_VAULT_WRAP_TTL = "X-Vault-Wrap-TTL";
    public static final String X_VAULT_NAMESPACE = "X-Vault-Namespace";

    protected <T> CompletionStage<VaultResponse<T>> buildResponse(VaultRequest<T> request, int statusCode, Collection<Map.Entry<String, String>> headers, byte[] body) {
        return CompletableFuture.completedStage(null).thenApply(none -> {
            VaultResponse response = new VaultResponse(request, statusCode, List.copyOf(headers), body);
            if (!response.isStatusCodeExpected() && !response.isUpgradedResponse()) {
                this.throwVaultException(request, statusCode, body);
            }
            return response;
        }).exceptionallyCompose(x -> {
            if (x instanceof CompletionException || x instanceof ExecutionException) {
                x = x.getCause();
            }
            if (x instanceof JsonProcessingException) {
                x = new VaultClientException((VaultRequest<?>)request, (Integer)statusCode, List.of("Failed to parse response body"), (Throwable)x);
            } else if (x instanceof ConnectException) {
                x = new VaultClientException((VaultRequest<?>)request, (Integer)statusCode, List.of("Unable to establish connection"), (Throwable)x);
            } else if (x instanceof TimeoutException) {
                x = new VaultClientException((VaultRequest<?>)request, (Integer)statusCode, List.of("HTTP request timed out"), (Throwable)x);
            }
            return CompletableFuture.failedStage(x);
        });
    }

    private void throwVaultException(VaultRequest<?> request, int statusCode, byte[] body) {
        String bodyText = null;
        List<String> errors = null;
        try {
            VaultErrorResponse errorResponse = null;
            try {
                errorResponse = (VaultErrorResponse)JsonMapping.mapper.readValue(body, VaultErrorResponse.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (errorResponse != null && errorResponse.errors() != null && !errorResponse.errors().isEmpty()) {
                errors = errorResponse.errors();
            } else {
                bodyText = new String(body, StandardCharsets.UTF_8).trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (errors != null) {
            throw new VaultClientException(request, (Integer)statusCode, errors, null);
        }
        throw new VaultClientException(request, (Integer)statusCode, bodyText, null);
    }
}

