/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.http.jdk;

import io.quarkus.vault.client.common.VaultRequest;
import io.quarkus.vault.client.common.VaultResponse;
import io.quarkus.vault.client.http.VaultHttpClient;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class JDKVaultHttpClient
extends VaultHttpClient {
    private final HttpClient httpClient;

    public JDKVaultHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public <T> CompletionStage<VaultResponse<T>> execute(VaultRequest<T> request) {
        return CompletableFuture.completedStage(request).thenApply(this::buildHTTPRequest).thenCompose(httpRequest -> this.httpClient.sendAsync((HttpRequest)httpRequest, HttpResponse.BodyHandlers.ofByteArray())).thenCompose(res -> this.buildResponse(request, res.statusCode(), JDKVaultHttpClient.headers(res), (byte[])res.body()));
    }

    private HttpRequest buildHTTPRequest(VaultRequest<?> request) {
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(request.getUri()).timeout(request.getTimeout());
        request.getHTTPHeaders().forEach(requestBuilder::header);
        HttpRequest.BodyPublisher body = request.getSerializedBody().map(HttpRequest.BodyPublishers::ofString).orElseGet(HttpRequest.BodyPublishers::noBody);
        return requestBuilder.method(request.getMethod().name(), body).build();
    }

    private static List<Map.Entry<String, String>> headers(HttpResponse<?> response) {
        ArrayList<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();
        response.headers().map().forEach((key, values) -> values.forEach(value -> headers.add(Map.entry(key, value))));
        return headers;
    }

    @Override
    public void close() {
    }
}

