/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client;

import io.quarkus.vault.client.Retry;
import io.quarkus.vault.client.api.VaultAuthAccessor;
import io.quarkus.vault.client.api.VaultSecretsAccessor;
import io.quarkus.vault.client.api.VaultSysAccessor;
import io.quarkus.vault.client.auth.VaultAppRoleAuthOptions;
import io.quarkus.vault.client.auth.VaultAppRoleTokenProvider;
import io.quarkus.vault.client.auth.VaultAuthRequest;
import io.quarkus.vault.client.auth.VaultKubernetesAuthOptions;
import io.quarkus.vault.client.auth.VaultKubernetesTokenProvider;
import io.quarkus.vault.client.auth.VaultStaticClientTokenAuthOptions;
import io.quarkus.vault.client.auth.VaultStaticClientTokenProvider;
import io.quarkus.vault.client.auth.VaultTokenProvider;
import io.quarkus.vault.client.auth.VaultUserPassAuthOptions;
import io.quarkus.vault.client.auth.VaultUserPassTokenProvider;
import io.quarkus.vault.client.common.VaultRequest;
import io.quarkus.vault.client.common.VaultRequestExecutor;
import io.quarkus.vault.client.common.VaultResponse;
import io.quarkus.vault.client.common.VaultTracingExecutor;
import io.quarkus.vault.client.logging.LogConfidentialityLevel;
import java.net.URL;
import java.nio.file.Path;
import java.time.Duration;
import java.time.InstantSource;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class VaultClient
implements VaultRequestExecutor {
    private final AtomicReference<VaultSecretsAccessor> secrets = new AtomicReference();
    private final AtomicReference<VaultAuthAccessor> auth = new AtomicReference();
    private final URL baseUrl;
    private final String apiVersion;
    private final VaultRequestExecutor executor;
    private final Duration requestTimeout;
    private final LogConfidentialityLevel logConfidentialityLevel;
    private final VaultTokenProvider tokenProvider;
    private final String namespace;
    private final InstantSource instantSource;

    public static Builder builder() {
        return new Builder();
    }

    private VaultClient(Builder builder) {
        this.baseUrl = Objects.requireNonNull(builder.baseUrl, "baseUrl is required");
        this.executor = Objects.requireNonNull(builder.executor, "executor is required");
        this.apiVersion = builder.apiVersion;
        this.logConfidentialityLevel = builder.logConfidentialityLevel;
        this.requestTimeout = builder.requestTimeout;
        this.tokenProvider = builder.tokenProvider;
        this.namespace = builder.namespace;
        this.instantSource = builder.instantSource;
    }

    public VaultSecretsAccessor secrets() {
        if (this.secrets.get() == null) {
            this.secrets.set(new VaultSecretsAccessor(this));
        }
        return this.secrets.get();
    }

    public VaultAuthAccessor auth() {
        if (this.auth.get() == null) {
            this.auth.set(new VaultAuthAccessor(this));
        }
        return this.auth.get();
    }

    public VaultSysAccessor sys() {
        return new VaultSysAccessor(this);
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public VaultRequestExecutor getExecutor() {
        return this.executor;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public LogConfidentialityLevel getLogConfidentialityLevel() {
        return this.logConfidentialityLevel;
    }

    public VaultTokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public <T> CompletionStage<VaultResponse<T>> execute(VaultRequest<T> request) {
        VaultRequest.Builder requestBuilder = request.builder();
        requestBuilder.baseUrl(this.baseUrl);
        if (this.requestTimeout != null) {
            requestBuilder.timeout(this.requestTimeout);
        }
        if (this.apiVersion != null) {
            requestBuilder.apiVersion(this.apiVersion);
        }
        if (this.logConfidentialityLevel != null) {
            requestBuilder.logConfidentialityLevel(this.logConfidentialityLevel);
        }
        if (!request.hasNamespace() && this.namespace != null) {
            requestBuilder.namespace(this.namespace);
        }
        if (request.hasToken() || this.tokenProvider == null) {
            return this.executor.execute(requestBuilder.rebuild());
        }
        AtomicReference<Object> appliedToken = new AtomicReference<Object>(null);
        CompletionStage providedToken = (CompletionStage)this.tokenProvider.apply(VaultAuthRequest.of(this, request, this.instantSource));
        Supplier responseSupplier = () -> providedToken.thenCompose(token -> {
            appliedToken.set(token);
            if (token == null) {
                requestBuilder.noToken();
            } else {
                requestBuilder.token(token.getClientToken());
            }
            return this.executor.execute(requestBuilder.rebuild());
        });
        return CompletableFuture.completedStage(0).thenCompose(new Retry(responseSupplier, 1L, appliedToken));
    }

    public Builder configure() {
        Builder builder = new Builder();
        builder.baseUrl = this.baseUrl;
        builder.apiVersion = this.apiVersion;
        builder.executor = this.executor;
        builder.tokenProvider = this.tokenProvider;
        builder.namespace = this.namespace;
        builder.requestTimeout = this.requestTimeout;
        builder.logConfidentialityLevel = this.logConfidentialityLevel;
        return builder;
    }

    public static class Builder {
        private URL baseUrl;
        private String apiVersion;
        private VaultRequestExecutor executor;
        private VaultTokenProvider tokenProvider;
        private String namespace;
        private Duration requestTimeout;
        private LogConfidentialityLevel logConfidentialityLevel;
        private InstantSource instantSource = InstantSource.system();

        public Builder baseUrl(URL baseUrl) {
            this.baseUrl = Objects.requireNonNull(baseUrl, "baseUrl is required");
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            try {
                return this.baseUrl(new URL(baseUrl));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid URL: " + baseUrl, e);
            }
        }

        public Builder apiVersion(String apiVersion) {
            this.apiVersion = Objects.requireNonNull(apiVersion, "apiVersion is required");
            assert (apiVersion.startsWith("v"));
            return this;
        }

        public Builder executor(VaultRequestExecutor executor) {
            this.executor = executor;
            return this;
        }

        public Builder clientToken(String token) {
            return this.clientToken(VaultStaticClientTokenAuthOptions.builder().token(token).build());
        }

        public Builder clientToken(VaultStaticClientTokenAuthOptions options) {
            return this.tokenProvider(new VaultStaticClientTokenProvider(options));
        }

        public Builder userPass(String username, String password) {
            return this.userPass(VaultUserPassAuthOptions.builder().username(username).password(password).build());
        }

        public Builder userPass(VaultUserPassAuthOptions options) {
            return this.tokenProvider(new VaultUserPassTokenProvider(options).caching(options.cachingRenewGracePeriod));
        }

        public Builder appRole(String roleId, String secretId) {
            return this.appRole(VaultAppRoleAuthOptions.builder().roleId(roleId).secretId(secretId).build());
        }

        public Builder appRole(VaultAppRoleAuthOptions options) {
            return this.tokenProvider(new VaultAppRoleTokenProvider(options).caching(options.cachingRenewGracePeriod));
        }

        public Builder kubernetes(String role, Path jwtTokenPath) {
            return this.kubernetes(VaultKubernetesAuthOptions.builder().role(role).jwtTokenPath(jwtTokenPath).build());
        }

        public Builder kubernetes(VaultKubernetesAuthOptions options) {
            return this.tokenProvider(new VaultKubernetesTokenProvider(options).caching(options.cachingRenewGracePeriod));
        }

        public Builder tokenProvider(VaultTokenProvider tokenProvider) {
            this.tokenProvider = tokenProvider;
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder requestTimeout(Duration requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public Builder logConfidentialityLevel(LogConfidentialityLevel logConfidentialityLevel) {
            this.logConfidentialityLevel = logConfidentialityLevel != null ? logConfidentialityLevel : LogConfidentialityLevel.HIGH;
            return this;
        }

        public Builder traceRequests() {
            Objects.requireNonNull(this.executor, "executor must be configured before tracing");
            if (!(this.executor instanceof VaultTracingExecutor)) {
                this.executor = new VaultTracingExecutor(this.executor);
            }
            return this;
        }

        public Builder instantSource(InstantSource instantSource) {
            this.instantSource = instantSource;
            return this;
        }

        public VaultClient build() {
            return new VaultClient(this);
        }
    }
}

