/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api;

import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRole;
import io.quarkus.vault.client.api.auth.kubernetes.VaultAuthKubernetes;
import io.quarkus.vault.client.api.auth.token.VaultAuthToken;
import io.quarkus.vault.client.api.auth.userpass.VaultAuthUserPass;
import io.quarkus.vault.client.common.VaultRequestExecutor;

public class VaultAuthAccessor {
    public static final String DEFAULT_APPROLE_MOUNT_PATH = "approle";
    public static final String DEFAULT_USERPASS_MOUNT_PATH = "userpass";
    public static final String DEFAULT_KUBERNETES_MOUNT_PATH = "kubernetes";
    private final VaultRequestExecutor executor;

    public VaultAuthAccessor(VaultRequestExecutor executor) {
        this.executor = executor;
    }

    public VaultRequestExecutor getExecutor() {
        return this.executor;
    }

    public VaultAuthAppRole appRole() {
        return new VaultAuthAppRole(this.executor, DEFAULT_APPROLE_MOUNT_PATH);
    }

    public VaultAuthAppRole appRole(String mountPath) {
        return new VaultAuthAppRole(this.executor, mountPath);
    }

    public VaultAuthUserPass userPass() {
        return new VaultAuthUserPass(this.executor, DEFAULT_USERPASS_MOUNT_PATH);
    }

    public VaultAuthUserPass userPass(String mountPath) {
        return new VaultAuthUserPass(this.executor, mountPath);
    }

    public VaultAuthKubernetes kubernetes() {
        return new VaultAuthKubernetes(this.executor, DEFAULT_KUBERNETES_MOUNT_PATH);
    }

    public VaultAuthKubernetes kubernetes(String mountPath) {
        return new VaultAuthKubernetes(this.executor, mountPath);
    }

    public VaultAuthToken token() {
        return new VaultAuthToken(this.executor);
    }
}

