/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.auth.kubernetes;

import io.quarkus.vault.client.api.auth.kubernetes.VaultAuthKubernetesConfigureParams;
import io.quarkus.vault.client.api.auth.kubernetes.VaultAuthKubernetesListRolesResultData;
import io.quarkus.vault.client.api.auth.kubernetes.VaultAuthKubernetesLoginAuthResult;
import io.quarkus.vault.client.api.auth.kubernetes.VaultAuthKubernetesReadConfigResultData;
import io.quarkus.vault.client.api.auth.kubernetes.VaultAuthKubernetesReadRoleResultData;
import io.quarkus.vault.client.api.auth.kubernetes.VaultAuthKubernetesRequestFactory;
import io.quarkus.vault.client.api.auth.kubernetes.VaultAuthKubernetesUpdateRoleParams;
import io.quarkus.vault.client.api.common.VaultCompletionStages;
import io.quarkus.vault.client.api.common.VaultLeasedResult;
import io.quarkus.vault.client.api.common.VaultMountableAPI;
import io.quarkus.vault.client.common.VaultRequestExecutor;
import io.quarkus.vault.client.common.VaultResponse;
import java.util.List;
import java.util.concurrent.CompletionStage;

public class VaultAuthKubernetes
extends VaultMountableAPI<VaultAuthKubernetesRequestFactory> {
    public static VaultAuthKubernetesRequestFactory FACTORY = VaultAuthKubernetesRequestFactory.INSTANCE;

    public VaultAuthKubernetes(VaultRequestExecutor executor, String mountPath, VaultAuthKubernetesRequestFactory factory) {
        super(executor, factory, mountPath);
    }

    public VaultAuthKubernetes(VaultRequestExecutor executor, String mountPath) {
        this(executor, mountPath, FACTORY);
    }

    public CompletionStage<VaultAuthKubernetesLoginAuthResult> login(String role, String jwt) {
        return this.executor.execute(((VaultAuthKubernetesRequestFactory)this.factory).login(this.mountPath, role, jwt)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getAuth);
    }

    public CompletionStage<Void> configure(VaultAuthKubernetesConfigureParams params) {
        return this.executor.execute(((VaultAuthKubernetesRequestFactory)this.factory).configure(this.mountPath, params)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<VaultAuthKubernetesReadConfigResultData> readConfig() {
        return this.executor.execute(((VaultAuthKubernetesRequestFactory)this.factory).readConfig(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<Void> updateRole(String roleName, VaultAuthKubernetesUpdateRoleParams params) {
        return this.executor.execute(((VaultAuthKubernetesRequestFactory)this.factory).updateRole(this.mountPath, roleName, params)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<VaultAuthKubernetesReadRoleResultData> readRole(String roleName) {
        return this.executor.execute(((VaultAuthKubernetesRequestFactory)this.factory).readRole(this.mountPath, roleName)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<List<String>> listRoles() {
        return this.executor.execute(((VaultAuthKubernetesRequestFactory)this.factory).listRoles(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultAuthKubernetesListRolesResultData)r.getData()).getKeys()).exceptionallyCompose(VaultCompletionStages.recoverNotFound(() -> List.of()));
    }

    public CompletionStage<Void> deleteRole(String roleName) {
        return this.executor.execute(((VaultAuthKubernetesRequestFactory)this.factory).deleteRole(this.mountPath, roleName)).thenApply(VaultResponse::getResult);
    }
}

