/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.auth.token;

import io.quarkus.vault.client.api.auth.token.VaultAuthTokenCreateResult;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenCreateTokenParams;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenListAccessorsResult;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenListRolesResult;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenLookupAccessorParams;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenLookupAccessorResult;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenLookupParams;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenLookupResult;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenLookupSelfResult;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenReadRoleResult;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenRenewAccessorParams;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenRenewAccessorResult;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenRenewParams;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenRenewResult;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenRenewSelfParams;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenRenewSelfResult;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenRevokeAccessorParams;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenRevokeParams;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenTidyTokensResult;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenUpdateRoleParams;
import io.quarkus.vault.client.api.common.VaultRequestFactory;
import io.quarkus.vault.client.common.VaultLeasedResultExtractor;
import io.quarkus.vault.client.common.VaultRequest;
import java.time.Duration;

public class VaultAuthTokenRequestFactory
extends VaultRequestFactory {
    public static final VaultAuthTokenRequestFactory INSTANCE = new VaultAuthTokenRequestFactory();

    public VaultAuthTokenRequestFactory() {
        super("[AUTH (token)]");
    }

    public VaultRequest<VaultAuthTokenListAccessorsResult> listAccessors() {
        return VaultRequest.list(this.getTraceOpName("List Accessors")).path("auth/token", "accessors").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultAuthTokenListAccessorsResult.class));
    }

    public VaultRequest<VaultAuthTokenCreateResult> create(boolean orphan, VaultAuthTokenCreateTokenParams params) {
        return VaultRequest.post(this.getTraceOpName("Create")).pathChoice(orphan, new String[]{"auth/token", "create-orphan"}, new String[]{"auth/token", "create"}).body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultAuthTokenCreateResult.class));
    }

    public VaultRequest<VaultAuthTokenCreateResult> create(VaultAuthTokenCreateTokenParams params) {
        return VaultRequest.post(this.getTraceOpName("Create")).path("auth/token", "create").body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultAuthTokenCreateResult.class));
    }

    public VaultRequest<VaultAuthTokenCreateResult> create(String roleName, VaultAuthTokenCreateTokenParams params) {
        return VaultRequest.post(this.getTraceOpName("Create")).path("auth/token", "create", roleName).body(params).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultAuthTokenCreateResult.class));
    }

    public VaultRequest<VaultAuthTokenLookupResult> lookup(String token) {
        return VaultRequest.post(this.getTraceOpName("Lookup")).path("auth/token", "lookup").body(new VaultAuthTokenLookupParams().setToken(token)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultAuthTokenLookupResult.class));
    }

    public VaultRequest<VaultAuthTokenLookupSelfResult> lookupSelf() {
        return VaultRequest.get(this.getTraceOpName("Lookup Self")).path("auth/token", "lookup-self").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultAuthTokenLookupSelfResult.class));
    }

    public VaultRequest<VaultAuthTokenLookupAccessorResult> lookupAccessor(String accessor) {
        return VaultRequest.post(this.getTraceOpName("Lookup Accessor")).path("auth/token", "lookup-accessor").body(new VaultAuthTokenLookupAccessorParams().setAccessor(accessor)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultAuthTokenLookupAccessorResult.class));
    }

    public VaultRequest<VaultAuthTokenRenewResult> renew(String token, Duration increment) {
        return VaultRequest.post(this.getTraceOpName("Renew")).path("auth/token", "renew").body(new VaultAuthTokenRenewParams().setToken(token).setIncrement(increment)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultAuthTokenRenewResult.class));
    }

    public VaultRequest<VaultAuthTokenRenewSelfResult> renewSelf(Duration increment) {
        return VaultRequest.post(this.getTraceOpName("Renew Self")).path("auth/token", "renew-self").body(new VaultAuthTokenRenewSelfParams().setIncrement(increment)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultAuthTokenRenewSelfResult.class));
    }

    public VaultRequest<VaultAuthTokenRenewAccessorResult> renewAccessor(String accessor, Duration increment) {
        return VaultRequest.post(this.getTraceOpName("Renew Accessor")).path("auth/token", "renew-accessor").body(new VaultAuthTokenRenewAccessorParams().setAccessor(accessor).setIncrement(increment)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultAuthTokenRenewAccessorResult.class));
    }

    public VaultRequest<Void> revoke(boolean orphanChildren, String token) {
        return VaultRequest.post(this.getTraceOpName("Revoke")).pathChoice(orphanChildren, new String[]{"auth/token", "revoke-orphan"}, new String[]{"auth/token", "revoke"}).body(new VaultAuthTokenRevokeParams().setToken(token)).expectNoContentStatus().build();
    }

    public VaultRequest<Void> revoke(String token) {
        return VaultRequest.post(this.getTraceOpName("Revoke")).path("auth/token", "revoke").body(new VaultAuthTokenRevokeParams().setToken(token)).expectNoContentStatus().build();
    }

    public VaultRequest<Void> revokeSelf() {
        return VaultRequest.post(this.getTraceOpName("Revoke Self")).path("auth/token", "revoke-self").expectNoContentStatus().build();
    }

    public VaultRequest<Void> revokeAccessor(String accessor) {
        return VaultRequest.post(this.getTraceOpName("Revoke Accessor")).path("auth/token", "revoke-accessor").body(new VaultAuthTokenRevokeAccessorParams().setAccessor(accessor)).expectNoContentStatus().build();
    }

    public VaultRequest<VaultAuthTokenReadRoleResult> readRole(String roleName) {
        return VaultRequest.get(this.getTraceOpName("Read Role")).path("auth/token", "roles", roleName).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultAuthTokenReadRoleResult.class));
    }

    public VaultRequest<VaultAuthTokenListRolesResult> listRoles() {
        return VaultRequest.list(this.getTraceOpName("List Roles")).path("auth/token", "roles").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultAuthTokenListRolesResult.class));
    }

    public VaultRequest<Void> updateRole(String roleName, VaultAuthTokenUpdateRoleParams params) {
        return VaultRequest.post(this.getTraceOpName("Update Role")).path("auth/token", "roles", roleName).body(params).expectNoContentStatus().build();
    }

    public VaultRequest<Void> deleteRole(String roleName) {
        return VaultRequest.delete(this.getTraceOpName("Delete Role")).path("auth/token", "roles", roleName).expectNoContentStatus().build();
    }

    public VaultRequest<VaultAuthTokenTidyTokensResult> tidyTokens() {
        return VaultRequest.post(this.getTraceOpName("Tidy Tokens")).path("auth/token", "tidy").expectOkOrAcceptedStatus().build(VaultLeasedResultExtractor.of(VaultAuthTokenTidyTokensResult.class));
    }
}

