/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.auth.userpass;

import io.quarkus.vault.client.api.auth.userpass.VaultAuthUserPassListUsersResult;
import io.quarkus.vault.client.api.auth.userpass.VaultAuthUserPassLoginParams;
import io.quarkus.vault.client.api.auth.userpass.VaultAuthUserPassLoginResult;
import io.quarkus.vault.client.api.auth.userpass.VaultAuthUserPassReadUserResult;
import io.quarkus.vault.client.api.auth.userpass.VaultAuthUserPassUpdateUserParams;
import io.quarkus.vault.client.api.auth.userpass.VaultAuthUserPassUpdateUserPasswordParams;
import io.quarkus.vault.client.api.auth.userpass.VaultAuthUserPassUpdateUserPoliciesParams;
import io.quarkus.vault.client.api.common.VaultRequestFactory;
import io.quarkus.vault.client.common.VaultLeasedResultExtractor;
import io.quarkus.vault.client.common.VaultRequest;
import java.util.List;

public class VaultAuthUserPassRequestFactory
extends VaultRequestFactory {
    public static final VaultAuthUserPassRequestFactory INSTANCE = new VaultAuthUserPassRequestFactory();

    public VaultAuthUserPassRequestFactory() {
        super("[AUTH (user/pass)]");
    }

    public VaultRequest<VaultAuthUserPassLoginResult> login(String mountPath, String username, String password) {
        return VaultRequest.post(this.getTraceOpName("Login")).path("auth", mountPath, "login", username).noToken().body(new VaultAuthUserPassLoginParams().setPassword(password)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultAuthUserPassLoginResult.class));
    }

    public VaultRequest<Void> updateUser(String mountPath, String username, VaultAuthUserPassUpdateUserParams params) {
        return VaultRequest.post(this.getTraceOpName("Update User")).path("auth", mountPath, "users", username).body(params).expectNoContentStatus().build();
    }

    public VaultRequest<VaultAuthUserPassReadUserResult> readUser(String mountPath, String username) {
        return VaultRequest.get(this.getTraceOpName("Read User")).path("auth", mountPath, "users", username).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultAuthUserPassReadUserResult.class));
    }

    public VaultRequest<Void> deleteUser(String mountPath, String username) {
        return VaultRequest.delete(this.getTraceOpName("Delete User")).path("auth", mountPath, "users", username).expectNoContentStatus().build();
    }

    public VaultRequest<Void> updateUserPassword(String mountPath, String username, String password) {
        return VaultRequest.post(this.getTraceOpName("Update User Password")).path("auth", mountPath, "users", username, "password").body(new VaultAuthUserPassUpdateUserPasswordParams().setPassword(password)).expectNoContentStatus().build();
    }

    public VaultRequest<Void> updateUserPolicies(String mountPath, String username, List<String> tokenPolicies) {
        return VaultRequest.post(this.getTraceOpName("Update User Policies")).path("auth", mountPath, "users", username, "policies").body(new VaultAuthUserPassUpdateUserPoliciesParams().setTokenPolicies(tokenPolicies)).expectNoContentStatus().build();
    }

    public VaultRequest<VaultAuthUserPassListUsersResult> listUsers(String mountPath) {
        return VaultRequest.list(this.getTraceOpName("List Users")).path("auth", mountPath, "users").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultAuthUserPassListUsersResult.class));
    }
}

