/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.common;

import io.quarkus.vault.client.api.common.VaultRequestFactory;
import io.quarkus.vault.client.api.common.VaultWrapInfo;
import io.quarkus.vault.client.api.common.VaultWrappedResult;
import io.quarkus.vault.client.common.VaultLeasedResultExtractor;
import io.quarkus.vault.client.common.VaultRequest;
import io.quarkus.vault.client.common.VaultRequestExecutor;
import java.time.Duration;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public class VaultAPI<F extends VaultRequestFactory> {
    protected final VaultRequestExecutor executor;
    protected final F factory;

    public VaultAPI(VaultRequestExecutor executor, F factory) {
        this.executor = executor;
        this.factory = factory;
    }

    public VaultRequestExecutor getExecutor() {
        return this.executor;
    }

    public <T> CompletionStage<VaultWrapInfo> wrapping(Duration wrapTTL, Function<F, VaultRequest<T>> builder) {
        VaultRequest<T> request = builder.apply(this.factory);
        VaultRequest<VaultWrappedResult> wrapRequest = request.builder().wrapTTL(wrapTTL).build(VaultLeasedResultExtractor.of(VaultWrappedResult.class));
        return this.executor.execute(wrapRequest).thenApply(r -> ((VaultWrappedResult)r.getResult()).getWrapInfo());
    }
}

