/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.quarkus.vault.client.common.VaultModel;

public enum VaultHashAlgorithm implements VaultModel
{
    SHA1("sha1"),
    SHA2_256("sha2-256"),
    SHA2_384("sha2-384"),
    SHA2_512("sha2-512"),
    SHA3_224("sha3-224"),
    SHA3_256("sha3-256"),
    SHA3_384("sha3-384"),
    SHA3_512("sha3-512"),
    NONE("none");

    private final String value;

    private VaultHashAlgorithm(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    public static VaultHashAlgorithm from(String value) {
        if (value == null) {
            return null;
        }
        for (VaultHashAlgorithm v : VaultHashAlgorithm.values()) {
            if (!v.value.equals(value)) continue;
            return v;
        }
        throw new IllegalArgumentException("Unknown value: " + value);
    }
}

