/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.secrets.database;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.quarkus.vault.client.api.secrets.database.VaultSecretsDatabaseCredentialConfig;
import io.quarkus.vault.client.api.secrets.database.VaultSecretsDatabaseCredentialType;
import io.quarkus.vault.client.common.VaultModel;

public class VaultSecretsDatabaseClientCertificateCredentialConfig
implements VaultSecretsDatabaseCredentialConfig {
    @JsonProperty(value="common_name_template")
    private String commonNameTemplate;
    @JsonProperty(value="ca_cert")
    private String caCert;
    @JsonProperty(value="ca_private_key")
    private String caPrivateKey;
    @JsonProperty(value="key_type")
    private KeyType keyType;
    @JsonProperty(value="key_bits")
    private VaultSecretsDatabaseCredentialConfig.KeyBits keyBits;
    @JsonProperty(value="signature_bits")
    private SignatureBits signatureBits;

    @Override
    public VaultSecretsDatabaseCredentialType getType() {
        return VaultSecretsDatabaseCredentialType.CLIENT_CERTIFICATE;
    }

    public String getCommonNameTemplate() {
        return this.commonNameTemplate;
    }

    public VaultSecretsDatabaseClientCertificateCredentialConfig setCommonNameTemplate(String commonNameTemplate) {
        this.commonNameTemplate = commonNameTemplate;
        return this;
    }

    public String getCaCert() {
        return this.caCert;
    }

    public VaultSecretsDatabaseClientCertificateCredentialConfig setCaCert(String caCert) {
        this.caCert = caCert;
        return this;
    }

    public String getCaPrivateKey() {
        return this.caPrivateKey;
    }

    public VaultSecretsDatabaseClientCertificateCredentialConfig setCaPrivateKey(String caPrivateKey) {
        this.caPrivateKey = caPrivateKey;
        return this;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public VaultSecretsDatabaseClientCertificateCredentialConfig setKeyType(KeyType keyType) {
        this.keyType = keyType;
        return this;
    }

    public VaultSecretsDatabaseCredentialConfig.KeyBits getKeyBits() {
        return this.keyBits;
    }

    public VaultSecretsDatabaseClientCertificateCredentialConfig setKeyBits(VaultSecretsDatabaseCredentialConfig.KeyBits keyBits) {
        this.keyBits = keyBits;
        return this;
    }

    public SignatureBits getSignatureBits() {
        return this.signatureBits;
    }

    public VaultSecretsDatabaseClientCertificateCredentialConfig setSignatureBits(SignatureBits signatureBits) {
        this.signatureBits = signatureBits;
        return this;
    }

    public static enum KeyType implements VaultModel
    {
        RSA("rsa"),
        EC("ec"),
        ED25519("ed25519");

        private final String value;

        private KeyType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getValue();
        }

        @JsonCreator
        public static KeyType from(String value) {
            if (value == null) {
                return null;
            }
            for (KeyType v : KeyType.values()) {
                if (!v.value.equals(value)) continue;
                return v;
            }
            throw new IllegalArgumentException("Unknown value: " + value);
        }
    }

    public static enum SignatureBits implements VaultModel
    {
        BITS_256("256"),
        BITS_384("384"),
        BITS_512("512");

        private final String value;

        private SignatureBits(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getValue();
        }

        @JsonCreator
        public static SignatureBits from(String value) {
            if (value == null) {
                return null;
            }
            for (SignatureBits v : SignatureBits.values()) {
                if (!v.value.equals(value)) continue;
                return v;
            }
            throw new IllegalArgumentException("Unknown value: " + value);
        }
    }
}

