/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.secrets.kv1;

import io.quarkus.vault.client.api.common.VaultLeasedResult;
import io.quarkus.vault.client.api.common.VaultMountableAPI;
import io.quarkus.vault.client.api.secrets.kv1.VaultSecretsKV1ListResultData;
import io.quarkus.vault.client.api.secrets.kv1.VaultSecretsKV1RequestFactory;
import io.quarkus.vault.client.common.VaultRequestExecutor;
import io.quarkus.vault.client.common.VaultResponse;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;

public class VaultSecretsKV1
extends VaultMountableAPI<VaultSecretsKV1RequestFactory> {
    public static VaultSecretsKV1RequestFactory FACTORY = VaultSecretsKV1RequestFactory.INSTANCE;

    public VaultSecretsKV1(VaultRequestExecutor executor, String mountPath, VaultSecretsKV1RequestFactory factory) {
        super(executor, factory, mountPath);
    }

    public VaultSecretsKV1(VaultRequestExecutor executor, String mountPath) {
        this(executor, mountPath, FACTORY);
    }

    public CompletionStage<Map<String, Object>> read(String path) {
        return this.executor.execute(((VaultSecretsKV1RequestFactory)this.factory).read(this.mountPath, path)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<List<String>> list(String path) {
        return this.executor.execute(((VaultSecretsKV1RequestFactory)this.factory).list(this.mountPath, path)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsKV1ListResultData)r.getData()).getKeys());
    }

    public CompletionStage<List<String>> list() {
        return this.executor.execute(((VaultSecretsKV1RequestFactory)this.factory).list(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSecretsKV1ListResultData)r.getData()).getKeys());
    }

    public CompletionStage<Void> update(String path, Map<String, Object> secrets) {
        return this.executor.execute(((VaultSecretsKV1RequestFactory)this.factory).update(this.mountPath, path, secrets)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> delete(String path) {
        return this.executor.execute(((VaultSecretsKV1RequestFactory)this.factory).delete(this.mountPath, path)).thenApply(VaultResponse::getResult);
    }
}

