/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.secrets.kv1;

import io.quarkus.vault.client.api.common.VaultRequestFactory;
import io.quarkus.vault.client.api.secrets.kv1.VaultSecretsKV1ListResult;
import io.quarkus.vault.client.api.secrets.kv1.VaultSecretsKV1ReadResult;
import io.quarkus.vault.client.common.VaultLeasedResultExtractor;
import io.quarkus.vault.client.common.VaultRequest;
import java.util.Map;

public class VaultSecretsKV1RequestFactory
extends VaultRequestFactory {
    public static final VaultSecretsKV1RequestFactory INSTANCE = new VaultSecretsKV1RequestFactory();

    public VaultSecretsKV1RequestFactory() {
        super("[SECRETS (kv1)]");
    }

    public VaultRequest<VaultSecretsKV1ReadResult> read(String mountPath, String path) {
        return VaultRequest.get(this.getTraceOpName("Read")).path(mountPath, path).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsKV1ReadResult.class));
    }

    public VaultRequest<VaultSecretsKV1ListResult> list(String mountPath, String path) {
        return VaultRequest.list(this.getTraceOpName("List")).path(mountPath, path).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsKV1ListResult.class));
    }

    public VaultRequest<VaultSecretsKV1ListResult> list(String mountPath) {
        return VaultRequest.list(this.getTraceOpName("List")).path(mountPath, "").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsKV1ListResult.class));
    }

    public VaultRequest<Void> update(String mountPath, String path, Map<String, Object> secrets) {
        return VaultRequest.post(this.getTraceOpName("Update")).path(mountPath, path).body(secrets).expectNoContentStatus().build();
    }

    public VaultRequest<Void> delete(String mountPath, String path) {
        return VaultRequest.delete(this.getTraceOpName("Delete")).path(mountPath, path).expectNoContentStatus().build();
    }
}

