/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.secrets.kv2;

import io.quarkus.vault.client.api.common.VaultRequestFactory;
import io.quarkus.vault.client.api.secrets.kv2.VaultSecretsKV2ListSecretsResult;
import io.quarkus.vault.client.api.secrets.kv2.VaultSecretsKV2PatchSecretParams;
import io.quarkus.vault.client.api.secrets.kv2.VaultSecretsKV2PatchSecretResult;
import io.quarkus.vault.client.api.secrets.kv2.VaultSecretsKV2ReadConfigResult;
import io.quarkus.vault.client.api.secrets.kv2.VaultSecretsKV2ReadSecretMetadataResult;
import io.quarkus.vault.client.api.secrets.kv2.VaultSecretsKV2ReadSecretResult;
import io.quarkus.vault.client.api.secrets.kv2.VaultSecretsKV2ReadSubkeysResult;
import io.quarkus.vault.client.api.secrets.kv2.VaultSecretsKV2SecretMetadataParams;
import io.quarkus.vault.client.api.secrets.kv2.VaultSecretsKV2UpdateConfigParams;
import io.quarkus.vault.client.api.secrets.kv2.VaultSecretsKV2UpdateSecretOptions;
import io.quarkus.vault.client.api.secrets.kv2.VaultSecretsKV2UpdateSecretParams;
import io.quarkus.vault.client.api.secrets.kv2.VaultSecretsKV2UpdateSecretResult;
import io.quarkus.vault.client.api.secrets.kv2.VaultSecretsKV2VersionsParams;
import io.quarkus.vault.client.common.VaultLeasedResultExtractor;
import io.quarkus.vault.client.common.VaultRequest;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;

public class VaultSecretsKV2RequestFactory
extends VaultRequestFactory {
    public static final VaultSecretsKV2RequestFactory INSTANCE = new VaultSecretsKV2RequestFactory();

    public VaultSecretsKV2RequestFactory() {
        super("[SECRETS (kv2)]");
    }

    public VaultRequest<Void> updateConfig(String mountPath, Integer maxVersions, Boolean casRequired, String deleteVersionAfter) {
        return VaultRequest.post(this.getTraceOpName("Update Config")).path(mountPath, "config").body(new VaultSecretsKV2UpdateConfigParams().setMaxVersions(maxVersions).setCasRequired(casRequired).setDeleteVersionAfter(deleteVersionAfter)).expectNoContentStatus().build();
    }

    public VaultRequest<VaultSecretsKV2ReadConfigResult> readConfig(String mountPath) {
        return VaultRequest.get(this.getTraceOpName("Read Config")).path(mountPath, "config").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsKV2ReadConfigResult.class));
    }

    public VaultRequest<VaultSecretsKV2ReadSecretResult> readSecret(String mountPath, String path, @Nullable Integer version) {
        return VaultRequest.get(this.getTraceOpName("Read Secret")).path(mountPath, "data", path).queryParam("version", version).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsKV2ReadSecretResult.class));
    }

    public VaultRequest<VaultSecretsKV2ReadSecretResult> readSecret(String mountPath, String path) {
        return VaultRequest.get(this.getTraceOpName("Read Secret")).path(mountPath, "data", path).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsKV2ReadSecretResult.class));
    }

    public VaultRequest<VaultSecretsKV2ReadSubkeysResult> readSubkeys(String mountPath, String path, @Nullable Integer version, @Nullable Integer depth) {
        return VaultRequest.get(this.getTraceOpName("Read Subkeys")).path(mountPath, "subkeys", path).queryParam(version != null, "version", version).queryParam(depth != null, "depth", depth).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsKV2ReadSubkeysResult.class));
    }

    public VaultRequest<VaultSecretsKV2ReadSubkeysResult> readSubkeys(String mountPath, String path) {
        return VaultRequest.get(this.getTraceOpName("Read Subkeys")).path(mountPath, "subkeys", path).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsKV2ReadSubkeysResult.class));
    }

    public VaultRequest<VaultSecretsKV2UpdateSecretResult> updateSecret(String mountPath, String path, VaultSecretsKV2UpdateSecretOptions options, Map<String, Object> data) {
        return VaultRequest.post(this.getTraceOpName("Update Secret")).path(mountPath, "data", path).body(new VaultSecretsKV2UpdateSecretParams().setOptions(options).setData(data)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsKV2UpdateSecretResult.class));
    }

    public VaultRequest<VaultSecretsKV2PatchSecretResult> patchSecret(String mountPath, String path, VaultSecretsKV2UpdateSecretOptions options, Map<String, Object> data) {
        return VaultRequest.patch(this.getTraceOpName("Patch Secret")).path(mountPath, "data", path).header("Content-Type", "application/merge-patch+json").body(new VaultSecretsKV2PatchSecretParams().setOptions(options).setData(data)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsKV2PatchSecretResult.class));
    }

    public VaultRequest<Void> deleteSecret(String mountPath, String path) {
        return VaultRequest.delete(this.getTraceOpName("Delete Secret")).path(mountPath, "data", path).expectNoContentStatus().build();
    }

    public VaultRequest<Void> deleteSecretVersions(String mountPath, String path, List<Integer> versions) {
        return VaultRequest.post(this.getTraceOpName("Delete Secret Versions")).path(mountPath, "delete", path).body(new VaultSecretsKV2VersionsParams().setVersions(versions)).expectNoContentStatus().build();
    }

    public VaultRequest<Void> undeleteSecretVersions(String mountPath, String path, List<Integer> versions) {
        return VaultRequest.post(this.getTraceOpName("Undelete Secret Versions")).path(mountPath, "undelete", path).body(new VaultSecretsKV2VersionsParams().setVersions(versions)).expectNoContentStatus().build();
    }

    public VaultRequest<Void> destroySecretVersions(String mountPath, String path, List<Integer> versions) {
        return VaultRequest.post(this.getTraceOpName("Destroy Secret Versions")).path(mountPath, "destroy", path).body(new VaultSecretsKV2VersionsParams().setVersions(versions)).expectNoContentStatus().build();
    }

    public VaultRequest<VaultSecretsKV2ListSecretsResult> listSecrets(String mountPath, String path) {
        return VaultRequest.list(this.getTraceOpName("List Secrets")).path(mountPath, "metadata", path).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsKV2ListSecretsResult.class));
    }

    public VaultRequest<VaultSecretsKV2ReadSecretMetadataResult> readSecretMetadata(String mountPath, String path) {
        return VaultRequest.get(this.getTraceOpName("Read Secret Metadata")).path(mountPath, "metadata", path).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsKV2ReadSecretMetadataResult.class));
    }

    public VaultRequest<Void> updateSecretMetadata(String mountPath, String path, @Nullable Integer maxVersions, @Nullable Boolean casRequired, @Nullable String deleteVersionAfter, @Nullable Map<String, Object> customMetadata) {
        return VaultRequest.post(this.getTraceOpName("Update Secret Metadata")).path(mountPath, "metadata", path).body(new VaultSecretsKV2SecretMetadataParams().setMaxVersions(maxVersions).setCasRequired(casRequired).setDeleteVersionAfter(deleteVersionAfter).setCustomMetadata(customMetadata)).expectNoContentStatus().build();
    }

    public VaultRequest<Void> patchSecretMetadata(String mountPath, String path, VaultSecretsKV2SecretMetadataParams params) {
        return VaultRequest.patch(this.getTraceOpName("Patch Secret Metadata")).path(mountPath, "metadata", path).header("Content-Type", "application/merge-patch+json").body(params).expectNoContentStatus().build();
    }

    public VaultRequest<Void> deleteSecretMetadata(String mountPath, String path) {
        return VaultRequest.delete(this.getTraceOpName("Delete Secret Metadata")).path(mountPath, "metadata", path).expectNoContentStatus().build();
    }
}

