/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.secrets.pki;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.quarkus.vault.client.common.VaultModel;

public enum VaultSecretsPKIFormat implements VaultModel
{
    PEM("pem"),
    DER("der"),
    PEM_BUNDLE("pem_bundle");

    private final String value;

    private VaultSecretsPKIFormat(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    public static VaultSecretsPKIFormat from(String value) {
        if (value == null) {
            return null;
        }
        for (VaultSecretsPKIFormat v : VaultSecretsPKIFormat.values()) {
            if (!v.value.equals(value)) continue;
            return v;
        }
        throw new IllegalArgumentException("Unknown value: " + value);
    }
}

