/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.secrets.pki;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.quarkus.vault.client.common.VaultModel;

public enum VaultSecretsPKISignatureBits implements VaultModel
{
    DEFAULT(0),
    SHA_256(256),
    SHA_384(384),
    SHA_512(512);

    private final int bits;

    @JsonValue
    public int getBits() {
        return this.bits;
    }

    private VaultSecretsPKISignatureBits(int bits) {
        this.bits = bits;
    }

    @JsonCreator
    public static VaultSecretsPKISignatureBits fromBits(int bits) {
        for (VaultSecretsPKISignatureBits keyBits : VaultSecretsPKISignatureBits.values()) {
            if (keyBits.getBits() != bits) continue;
            return keyBits;
        }
        throw new IllegalArgumentException("Unknown bits: " + bits);
    }
}

