/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.secrets.rabbitmq;

import io.quarkus.vault.client.api.common.VaultRequestFactory;
import io.quarkus.vault.client.api.secrets.rabbitmq.VaultSecretsRabbitMQConfigureConnectionParams;
import io.quarkus.vault.client.api.secrets.rabbitmq.VaultSecretsRabbitMQConfigureLeaseParams;
import io.quarkus.vault.client.api.secrets.rabbitmq.VaultSecretsRabbitMQGenerateCredentialsResult;
import io.quarkus.vault.client.api.secrets.rabbitmq.VaultSecretsRabbitMQReadLeaseConfigResult;
import io.quarkus.vault.client.api.secrets.rabbitmq.VaultSecretsRabbitMQReadRoleResult;
import io.quarkus.vault.client.api.secrets.rabbitmq.VaultSecretsRabbitMQUpdateRoleParams;
import io.quarkus.vault.client.api.secrets.rabbitmq.VaultSecretsRabbitMQVHosts;
import io.quarkus.vault.client.common.VaultLeasedResultExtractor;
import io.quarkus.vault.client.common.VaultRequest;
import java.time.Duration;
import java.util.List;
import java.util.Map;

public class VaultSecretsRabbitMQRequestFactory
extends VaultRequestFactory {
    public static final VaultSecretsRabbitMQRequestFactory INSTANCE = new VaultSecretsRabbitMQRequestFactory();

    public VaultSecretsRabbitMQRequestFactory() {
        super("[SECRETS (rabbitmq)]");
    }

    public VaultRequest<Void> configureConnection(String mountPath, VaultSecretsRabbitMQConfigureConnectionParams params) {
        return VaultRequest.post(this.getTraceOpName("Configure Connection")).path(mountPath, "config", "connection").body(params).expectNoContentStatus().build();
    }

    public VaultRequest<Void> configureLease(String mountPath, Duration ttl, Duration maxTtl) {
        return VaultRequest.post(this.getTraceOpName("Configure Lease")).path(mountPath, "config", "lease").body(new VaultSecretsRabbitMQConfigureLeaseParams().setTtl(ttl).setMaxTtl(maxTtl)).expectNoContentStatus().build();
    }

    public VaultRequest<VaultSecretsRabbitMQReadLeaseConfigResult> readLeaseConfig(String mountPath) {
        return VaultRequest.get(this.getTraceOpName("Read Lease Config")).path(mountPath, "config", "lease").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsRabbitMQReadLeaseConfigResult.class));
    }

    public VaultRequest<Void> updateRole(String mountPath, String roleName, List<String> tags, VaultSecretsRabbitMQVHosts vhosts, Map<String, VaultSecretsRabbitMQVHosts> vhostTopics) {
        return VaultRequest.post(this.getTraceOpName("Update Role")).path(mountPath, "roles", roleName).body(new VaultSecretsRabbitMQUpdateRoleParams().setTags(tags).setVhosts(vhosts).setVhostTopics(vhostTopics)).expectNoContentStatus().build();
    }

    public VaultRequest<VaultSecretsRabbitMQReadRoleResult> readRole(String mountPath, String roleName) {
        return VaultRequest.get(this.getTraceOpName("Read Role")).path(mountPath, "roles", roleName).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsRabbitMQReadRoleResult.class));
    }

    public VaultRequest<Void> deleteRole(String mountPath, String roleName) {
        return VaultRequest.delete(this.getTraceOpName("Delete Role")).path(mountPath, "roles", roleName).expectNoContentStatus().build();
    }

    public VaultRequest<VaultSecretsRabbitMQGenerateCredentialsResult> generateCredentials(String mountPath, String roleName) {
        return VaultRequest.get(this.getTraceOpName("Generate Credentials")).path(mountPath, "creds", roleName).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsRabbitMQGenerateCredentialsResult.class));
    }
}

