/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.secrets.totp;

import io.quarkus.vault.client.api.common.VaultRequestFactory;
import io.quarkus.vault.client.api.secrets.totp.VaultSecretsTOTPCreateKeyParams;
import io.quarkus.vault.client.api.secrets.totp.VaultSecretsTOTPCreateKeyResult;
import io.quarkus.vault.client.api.secrets.totp.VaultSecretsTOTPGenerateCodeResult;
import io.quarkus.vault.client.api.secrets.totp.VaultSecretsTOTPListKeysResult;
import io.quarkus.vault.client.api.secrets.totp.VaultSecretsTOTPReadKeyResult;
import io.quarkus.vault.client.api.secrets.totp.VaultSecretsTOTPValidateCodeParams;
import io.quarkus.vault.client.api.secrets.totp.VaultSecretsTOTPValidateCodeResult;
import io.quarkus.vault.client.common.VaultLeasedResultExtractor;
import io.quarkus.vault.client.common.VaultRequest;

public class VaultSecretsTOTPRequestFactory
extends VaultRequestFactory {
    public static final VaultSecretsTOTPRequestFactory INSTANCE = new VaultSecretsTOTPRequestFactory();

    public VaultSecretsTOTPRequestFactory() {
        super("[SECRETS (totp)]");
    }

    public VaultRequest<VaultSecretsTOTPCreateKeyResult> createKey(String mountPath, String name, VaultSecretsTOTPCreateKeyParams params) {
        return VaultRequest.post(this.getTraceOpName("Create Key")).path(mountPath, "keys", name).body(params).expectOkOrNoContentStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTOTPCreateKeyResult.class));
    }

    public VaultRequest<VaultSecretsTOTPReadKeyResult> readKey(String mountPath, String name) {
        return VaultRequest.get(this.getTraceOpName("Read Key")).path(mountPath, "keys", name).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTOTPReadKeyResult.class));
    }

    public VaultRequest<VaultSecretsTOTPListKeysResult> listKeys(String mountPath) {
        return VaultRequest.list(this.getTraceOpName("List Keys")).path(mountPath, "keys").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTOTPListKeysResult.class));
    }

    public VaultRequest<Void> deleteKey(String mountPath, String name) {
        return VaultRequest.delete(this.getTraceOpName("Delete Key")).path(mountPath, "keys", name).expectNoContentStatus().build();
    }

    public VaultRequest<VaultSecretsTOTPGenerateCodeResult> generateCode(String mountPath, String name) {
        return VaultRequest.get(this.getTraceOpName("Generate Code")).path(mountPath, "code", name).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTOTPGenerateCodeResult.class));
    }

    public VaultRequest<VaultSecretsTOTPValidateCodeResult> validateCode(String mountPath, String name, String code) {
        return VaultRequest.post(this.getTraceOpName("Validate Code")).path(mountPath, "code", name).body(new VaultSecretsTOTPValidateCodeParams().setCode(code)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSecretsTOTPValidateCodeResult.class));
    }
}

