/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.secrets.transit;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.quarkus.vault.client.common.VaultModel;

public enum VaultSecretsTransitExportKeyType implements VaultModel
{
    ENCRYPTION_KEY("encryption-key"),
    SIGNING_KEY("signing-key"),
    HMAC_KEY("hmac-key"),
    PUBLIC_KEY("public-key"),
    CERTIFICATE_CHAIN("certificate-chain");

    private final String value;

    private VaultSecretsTransitExportKeyType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    public static VaultSecretsTransitExportKeyType from(String value) {
        if (value == null) {
            return null;
        }
        for (VaultSecretsTransitExportKeyType v : VaultSecretsTransitExportKeyType.values()) {
            if (!v.value.equals(value)) continue;
            return v;
        }
        throw new IllegalArgumentException("Unknown value: " + value);
    }
}

