/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.secrets.transit;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.quarkus.vault.client.common.VaultModel;

public enum VaultSecretsTransitMarshalingAlgorithm implements VaultModel
{
    ASN1("asn1"),
    JWS("jws");

    private final String value;

    private VaultSecretsTransitMarshalingAlgorithm(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    public static VaultSecretsTransitMarshalingAlgorithm from(String value) {
        if (value == null) {
            return null;
        }
        for (VaultSecretsTransitMarshalingAlgorithm v : VaultSecretsTransitMarshalingAlgorithm.values()) {
            if (!v.value.equals(value)) continue;
            return v;
        }
        throw new IllegalArgumentException("Unknown value: " + value);
    }
}

