/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.sys.leases;

import io.quarkus.vault.client.api.common.VaultRequestFactory;
import io.quarkus.vault.client.api.sys.leases.VaultSysLeasesCountResult;
import io.quarkus.vault.client.api.sys.leases.VaultSysLeasesListResult;
import io.quarkus.vault.client.api.sys.leases.VaultSysLeasesReadParams;
import io.quarkus.vault.client.api.sys.leases.VaultSysLeasesReadResult;
import io.quarkus.vault.client.api.sys.leases.VaultSysLeasesRenewParams;
import io.quarkus.vault.client.api.sys.leases.VaultSysLeasesRenewResult;
import io.quarkus.vault.client.api.sys.leases.VaultSysLeasesRevokeForceParams;
import io.quarkus.vault.client.api.sys.leases.VaultSysLeasesRevokeParams;
import io.quarkus.vault.client.api.sys.leases.VaultSysLeasesRevokePrefixParams;
import io.quarkus.vault.client.common.VaultLeasedResultExtractor;
import io.quarkus.vault.client.common.VaultRequest;
import java.time.Duration;

public class VaultSysLeasesRequestFactory
extends VaultRequestFactory {
    public static final VaultSysLeasesRequestFactory INSTANCE = new VaultSysLeasesRequestFactory();

    public VaultSysLeasesRequestFactory() {
        super("[SYS (leases)]");
    }

    public VaultRequest<VaultSysLeasesReadResult> read(String leaseId) {
        return VaultRequest.post(this.getTraceOpName("Read")).path("sys", "leases", "lookup").body(new VaultSysLeasesReadParams().setLeaseId(leaseId)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSysLeasesReadResult.class));
    }

    public VaultRequest<VaultSysLeasesListResult> list(String prefix) {
        return VaultRequest.list(this.getTraceOpName("List")).path("sys", "leases", "lookup", prefix).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSysLeasesListResult.class));
    }

    public VaultRequest<VaultSysLeasesRenewResult> renew(String leaseId, Duration increment) {
        return VaultRequest.post(this.getTraceOpName("Renew")).path("sys", "leases", "renew").body(new VaultSysLeasesRenewParams().setLeaseId(leaseId).setIncrement(increment)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSysLeasesRenewResult.class));
    }

    public VaultRequest<Void> revoke(String leaseId, boolean sync) {
        return VaultRequest.post(this.getTraceOpName("Revoke")).path("sys", "leases", "revoke").body(new VaultSysLeasesRevokeParams().setLeaseId(leaseId).setSync(sync)).expectNoContentStatus().build();
    }

    public VaultRequest<Void> revokeForce(String prefix) {
        return VaultRequest.post(this.getTraceOpName("Revoke Force")).path("sys", "leases", "revoke-force", prefix).body(new VaultSysLeasesRevokeForceParams().setPrefix(prefix)).expectNoContentStatus().build();
    }

    public VaultRequest<Void> revokePrefix(String prefix) {
        return VaultRequest.post(this.getTraceOpName("Revoke Prefix")).path("sys", "leases", "revoke-prefix", prefix).body(new VaultSysLeasesRevokePrefixParams().setPrefix(prefix)).expectNoContentStatus().build();
    }

    public VaultRequest<Void> tidy() {
        return VaultRequest.post(this.getTraceOpName("Tidy")).path("sys", "leases", "tidy").expectOkOrAcceptedStatus().build();
    }

    public VaultRequest<VaultSysLeasesCountResult> count(String type, Boolean includeChildNamespaces) {
        return VaultRequest.get(this.getTraceOpName("Count")).path("sys", "leases", "count").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSysLeasesCountResult.class));
    }
}

