/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.sys.mounts;

import io.quarkus.vault.client.api.common.VaultAPI;
import io.quarkus.vault.client.api.common.VaultLeasedResult;
import io.quarkus.vault.client.api.sys.mounts.VaultSysMountsEnableConfig;
import io.quarkus.vault.client.api.sys.mounts.VaultSysMountsFullMountInfo;
import io.quarkus.vault.client.api.sys.mounts.VaultSysMountsMountInfo;
import io.quarkus.vault.client.api.sys.mounts.VaultSysMountsReadTuneResultData;
import io.quarkus.vault.client.api.sys.mounts.VaultSysMountsRequestFactory;
import io.quarkus.vault.client.api.sys.mounts.VaultSysMountsTuneParams;
import io.quarkus.vault.client.common.VaultRequestExecutor;
import io.quarkus.vault.client.common.VaultResponse;
import java.util.Map;
import java.util.concurrent.CompletionStage;

public class VaultSysMounts
extends VaultAPI<VaultSysMountsRequestFactory> {
    public static VaultSysMountsRequestFactory FACTORY = VaultSysMountsRequestFactory.INSTANCE;

    public VaultSysMounts(VaultRequestExecutor executor, VaultSysMountsRequestFactory factory) {
        super(executor, factory);
    }

    public VaultSysMounts(VaultRequestExecutor executor) {
        this(executor, FACTORY);
    }

    public CompletionStage<Map<String, VaultSysMountsMountInfo>> list() {
        return this.executor.execute(((VaultSysMountsRequestFactory)this.factory).list()).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSysMountsFullMountInfo> read(String path) {
        return this.executor.execute(((VaultSysMountsRequestFactory)this.factory).read(path)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<Void> enable(String path, String type, String description, VaultSysMountsEnableConfig config, Map<String, Object> options) {
        return this.executor.execute(((VaultSysMountsRequestFactory)this.factory).enable(path, type, description, config, options)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> disable(String path) {
        return this.executor.execute(((VaultSysMountsRequestFactory)this.factory).disable(path)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<VaultSysMountsReadTuneResultData> readTune(String path) {
        return this.executor.execute(((VaultSysMountsRequestFactory)this.factory).readTune(path)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<Void> tune(String path, VaultSysMountsTuneParams params) {
        return this.executor.execute(((VaultSysMountsRequestFactory)this.factory).tune(path, params)).thenApply(VaultResponse::getResult);
    }
}

