/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.sys.tools;

import io.quarkus.vault.client.api.common.VaultFormat;
import io.quarkus.vault.client.api.common.VaultHashAlgorithm;
import io.quarkus.vault.client.api.common.VaultRandomSource;
import io.quarkus.vault.client.api.common.VaultRequestFactory;
import io.quarkus.vault.client.api.sys.tools.VaultSysToolsHashParams;
import io.quarkus.vault.client.api.sys.tools.VaultSysToolsHashResult;
import io.quarkus.vault.client.api.sys.tools.VaultSysToolsRandomParams;
import io.quarkus.vault.client.api.sys.tools.VaultSysToolsRandomResult;
import io.quarkus.vault.client.common.VaultLeasedResultExtractor;
import io.quarkus.vault.client.common.VaultRequest;

public class VaultSysToolsRequestFactory
extends VaultRequestFactory {
    public static final VaultSysToolsRequestFactory INSTANCE = new VaultSysToolsRequestFactory();

    public VaultSysToolsRequestFactory() {
        super("[SYS (tools)]");
    }

    public VaultRequest<VaultSysToolsRandomResult> random(Integer bytes, VaultRandomSource source, VaultFormat format) {
        return VaultRequest.post(this.getTraceOpName("Random")).path("sys", "tools", "random", source, bytes).body(new VaultSysToolsRandomParams().setFormat(format)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSysToolsRandomResult.class));
    }

    public VaultRequest<VaultSysToolsHashResult> hash(VaultHashAlgorithm algorithm, byte[] input, VaultFormat format) {
        return VaultRequest.post(this.getTraceOpName("Hash")).path("sys", "tools", "hash", algorithm).body(new VaultSysToolsHashParams().setInput(input).setFormat(format)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSysToolsHashResult.class));
    }
}

