/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.auth.unwrap;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.quarkus.vault.client.VaultClientException;
import io.quarkus.vault.client.api.sys.wrapping.VaultSysWrapping;
import io.quarkus.vault.client.api.sys.wrapping.VaultSysWrappingUnwrapResult;
import io.quarkus.vault.client.auth.VaultAuthRequest;
import io.quarkus.vault.client.auth.unwrap.VaultValueProvider;
import io.quarkus.vault.client.common.VaultRequestExecutor;
import io.quarkus.vault.client.json.JsonMapping;
import io.quarkus.vault.client.logging.LogConfidentialityLevel;
import java.time.Duration;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;

public abstract class VaultUnwrappingValueProvider<UnwrapResult>
implements VaultValueProvider {
    private static final Logger log = Logger.getLogger(VaultUnwrappingValueProvider.class.getName());
    private static final Cache<String, CompletionStage<String>> unwrappingCache = Caffeine.newBuilder().expireAfterWrite(Duration.ofHours(1L)).build();
    private final String wrappingToken;

    protected VaultUnwrappingValueProvider(String wrappingToken) {
        this.wrappingToken = wrappingToken;
    }

    public abstract String getType();

    public abstract Class<? extends UnwrapResult> getUnwrapResultType();

    public abstract String extractClientToken(UnwrapResult var1);

    @Override
    public CompletionStage<String> apply(VaultAuthRequest unwrapRequest) {
        return (CompletionStage)unwrappingCache.get((Object)this.wrappingToken, token -> {
            VaultRequestExecutor executor = unwrapRequest.getExecutor();
            return executor.execute(VaultSysWrapping.FACTORY.unwrap((String)token)).thenApply(response -> {
                VaultSysWrappingUnwrapResult result = (VaultSysWrappingUnwrapResult)response.getResult();
                Object value = result.getAuth() != null ? result.getAuth() : result.getData();
                Object unwrappedValue = JsonMapping.mapper.convertValue(value, this.getUnwrapResultType());
                String unwrappedClientToken = this.extractClientToken(unwrappedValue);
                String displayValue = unwrapRequest.getRequest().getLogConfidentialityLevel().maskWithTolerance(unwrappedClientToken, LogConfidentialityLevel.LOW);
                log.fine("unwrapped " + this.getType() + ": " + displayValue);
                return unwrappedClientToken;
            }).exceptionally(e -> {
                VaultClientException ve;
                if (e instanceof CompletionException || e instanceof ExecutionException) {
                    e = e.getCause();
                }
                if (e instanceof VaultClientException && (ve = (VaultClientException)e).getStatus() == 400) {
                    String message = "wrapping token is not valid or does not exist; this means that the token has already expired (if so you can increase the ttl on the wrapping token) or has been consumed by somebody else (potentially indicating that the wrapping token has been stolen)";
                    throw ve.withError(message);
                }
                if (e instanceof RuntimeException) {
                    RuntimeException re = (RuntimeException)e;
                    throw re;
                }
                throw new RuntimeException((Throwable)e);
            });
        });
    }
}

