/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.common;

import io.quarkus.vault.client.VaultClientException;
import io.quarkus.vault.client.common.VaultResponse;
import io.quarkus.vault.client.common.VaultResultExtractor;
import io.quarkus.vault.client.json.JsonMapping;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

public class VaultJSONResultExtractor<T>
implements VaultResultExtractor<T> {
    protected final Class<T> resultClass;

    public VaultJSONResultExtractor(Class<T> resultClass) {
        this.resultClass = resultClass;
    }

    public static <T> VaultJSONResultExtractor<T> of(Class<T> resultClass) {
        return new VaultJSONResultExtractor<T>(resultClass);
    }

    @Override
    public Optional<T> extract(VaultResponse<T> response) {
        return VaultJSONResultExtractor.extract(response, this.resultClass);
    }

    public static <T> Optional<T> extract(VaultResponse<T> response, Class<T> resultClass) {
        return response.getBody().map(body -> {
            try {
                return JsonMapping.mapper.readValue(body, resultClass);
            }
            catch (IOException e) {
                List<String> errors = e.getMessage() != null && !e.getMessage().isBlank() ? List.of("Failed to parse response body", e.getMessage()) : List.of("Failed to parse response body");
                throw new VaultClientException(response, errors, e);
            }
        });
    }
}

