/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.common;

import io.quarkus.vault.client.common.VaultRequest;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class VaultResponse<T> {
    private final VaultRequest<T> request;
    private final int statusCode;
    private final List<Map.Entry<String, String>> headers;
    private final byte[] body;

    public VaultResponse(VaultRequest<T> request, int statusCode, List<Map.Entry<String, String>> headers, byte[] body) {
        this.request = request;
        this.statusCode = statusCode;
        this.headers = headers != null ? headers : List.of();
        this.body = body;
    }

    public VaultRequest<T> getRequest() {
        return this.request;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public List<Map.Entry<String, String>> getHeaders() {
        return this.headers;
    }

    public Optional<byte[]> getBody() {
        if (this.body == null || this.body.length == 0) {
            return Optional.empty();
        }
        return Optional.of(this.body);
    }

    public boolean isSuccessful() {
        return this.statusCode >= 200 && this.statusCode < 300;
    }

    public boolean isStatusCodeExpected() {
        List<Integer> expected = this.request.getExpectedStatusCodes();
        return expected.isEmpty() || expected.contains(this.statusCode);
    }

    public boolean isUpgradedResponse() {
        return this.statusCode == 200 && this.request.getExpectedStatusCodes().equals(List.of(Integer.valueOf(204)));
    }

    public T getResult() {
        return this.request.getResultExtractor().extract(this).orElse(null);
    }

    public Optional<String> getBodyAsString() {
        return Optional.ofNullable(this.body).map(String::new);
    }
}

