/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.common;

import io.quarkus.vault.client.common.VaultRequest;
import io.quarkus.vault.client.common.VaultRequestExecutor;
import io.quarkus.vault.client.common.VaultResponse;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VaultTracingExecutor
implements VaultRequestExecutor {
    private static final Logger log = Logger.getLogger(VaultTracingExecutor.class.getName());
    private final VaultRequestExecutor delegate;

    public VaultTracingExecutor(VaultRequestExecutor delegate) {
        this.delegate = delegate;
    }

    @Override
    public <T> CompletionStage<VaultResponse<T>> execute(VaultRequest<T> request) {
        log.info("Executing: " + request.getOperation() + System.lineSeparator() + this.getCurlFormattedRequest(request));
        return this.delegate.execute(request).thenApply(response -> {
            String message = "Response: " + request.getOperation() + System.lineSeparator() + this.getHTTPFormattedResponse((VaultResponse<?>)response) + System.lineSeparator();
            log.log(response.isSuccessful() ? Level.INFO : Level.WARNING, message);
            return response;
        }).exceptionallyCompose(error -> {
            log.log(Level.SEVERE, "Request failed: " + error);
            return CompletableFuture.failedStage(error);
        });
    }

    private String getCurlFormattedRequest(VaultRequest<?> request) {
        StringBuilder builder = new StringBuilder();
        builder.append("curl -X ").append((Object)request.getMethod()).append(" \\").append(System.lineSeparator());
        request.getHTTPHeaders().forEach((key, value) -> builder.append("  -H \"").append((String)key).append(": ").append((String)value).append("\" \\").append(System.lineSeparator()));
        request.getSerializedBody().ifPresent(body -> builder.append("  -d '").append((String)body).append("' \\").append(System.lineSeparator()));
        builder.append("  ").append(request.getUrl());
        return builder.toString();
    }

    private String getHTTPFormattedResponse(VaultResponse<?> response) {
        StringBuilder builder = new StringBuilder();
        builder.append("HTTP/1.1 ").append(response.getStatusCode()).append(System.lineSeparator());
        response.getHeaders().forEach(entry -> builder.append((String)entry.getKey()).append(": ").append((String)entry.getValue()).append(System.lineSeparator()));
        builder.append(System.lineSeparator());
        response.getBodyAsString().ifPresent(builder::append);
        return builder.toString();
    }
}

