/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.quarkus.vault.client.json.VaultModule;

public class JsonMapping {
    public static final ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new Jdk8Module());

    public static <T> T convert(Object data, Class<T> type) {
        try {
            return (T)mapper.convertValue(data, type);
        }
        catch (Exception e) {
            throw new RuntimeException("Error converting unwrapped result to expected type: " + type, e);
        }
    }

    public static <T> T convert(Object data, TypeReference<T> type) {
        try {
            return (T)mapper.convertValue(data, type);
        }
        catch (Exception e) {
            throw new RuntimeException("Error converting unwrapped result to expected type: " + type, e);
        }
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.registerModule((Module)VaultModule.INSTANCE);
    }
}

