/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.time.Duration;
import java.util.Locale;

public class VaultDurationStringDeserializer
extends StdDeserializer<Duration> {
    public VaultDurationStringDeserializer() {
        super(Duration.class);
    }

    public Duration deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        switch (p.currentToken()) {
            case VALUE_STRING: {
                return Duration.parse("PT" + p.getText().toUpperCase(Locale.ROOT));
            }
            case VALUE_NUMBER_INT: {
                return Duration.ofSeconds(p.getLongValue());
            }
        }
        throw ctxt.wrongTokenException(p, Duration.class, p.currentToken(), "Expected string or number");
    }
}

