/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.time.Duration;
import java.util.Locale;

public class VaultDurationStringSerializer
extends StdSerializer<Duration> {
    public VaultDurationStringSerializer() {
        super(Duration.class);
    }

    public void serialize(Duration value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        String fmt = value.toString();
        if (fmt.startsWith("PT")) {
            fmt = fmt.substring(2);
        }
        fmt = fmt.toLowerCase(Locale.ROOT);
        gen.writeString(fmt);
    }
}

