/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.auth.userpass;

import io.quarkus.vault.client.api.auth.userpass.VaultAuthUserPassListUsersResultData;
import io.quarkus.vault.client.api.auth.userpass.VaultAuthUserPassLoginAuthResult;
import io.quarkus.vault.client.api.auth.userpass.VaultAuthUserPassReadUserResultData;
import io.quarkus.vault.client.api.auth.userpass.VaultAuthUserPassRequestFactory;
import io.quarkus.vault.client.api.auth.userpass.VaultAuthUserPassUpdateUserParams;
import io.quarkus.vault.client.api.common.VaultLeasedResult;
import io.quarkus.vault.client.api.common.VaultMountableAPI;
import io.quarkus.vault.client.common.VaultRequestExecutor;
import io.quarkus.vault.client.common.VaultResponse;
import java.util.List;
import java.util.concurrent.CompletionStage;

public class VaultAuthUserPass
extends VaultMountableAPI<VaultAuthUserPassRequestFactory> {
    public static VaultAuthUserPassRequestFactory FACTORY = VaultAuthUserPassRequestFactory.INSTANCE;

    public VaultAuthUserPass(VaultRequestExecutor executor, String mountPath, VaultAuthUserPassRequestFactory factory) {
        super(executor, factory, mountPath);
    }

    public VaultAuthUserPass(VaultRequestExecutor executor, String mountPath) {
        this(executor, mountPath, FACTORY);
    }

    public CompletionStage<VaultAuthUserPassLoginAuthResult> login(String username, String password) {
        return this.executor.execute(((VaultAuthUserPassRequestFactory)this.factory).login(this.mountPath, username, password)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getAuth);
    }

    public CompletionStage<Void> updateUser(String username, VaultAuthUserPassUpdateUserParams params) {
        return this.executor.execute(((VaultAuthUserPassRequestFactory)this.factory).updateUser(this.mountPath, username, params)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<VaultAuthUserPassReadUserResultData> readUser(String username) {
        return this.executor.execute(((VaultAuthUserPassRequestFactory)this.factory).readUser(this.mountPath, username)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<Void> deleteUser(String username) {
        return this.executor.execute(((VaultAuthUserPassRequestFactory)this.factory).deleteUser(this.mountPath, username)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> updateUserPassword(String username, String password) {
        return this.executor.execute(((VaultAuthUserPassRequestFactory)this.factory).updateUserPassword(this.mountPath, username, password)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> updateUserPolicies(String username, List<String> tokenPolicies) {
        return this.executor.execute(((VaultAuthUserPassRequestFactory)this.factory).updateUserPolicies(this.mountPath, username, tokenPolicies)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<List<String>> listUsers() {
        return this.executor.execute(((VaultAuthUserPassRequestFactory)this.factory).listUsers(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultAuthUserPassListUsersResultData)r.getData()).getKeys());
    }
}

