/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.sys.plugins;

import io.quarkus.vault.client.api.common.VaultAPI;
import io.quarkus.vault.client.api.common.VaultLeasedResult;
import io.quarkus.vault.client.api.sys.plugins.VaultSysPluginsListAuthResultData;
import io.quarkus.vault.client.api.sys.plugins.VaultSysPluginsListDatabaseResultData;
import io.quarkus.vault.client.api.sys.plugins.VaultSysPluginsListResultData;
import io.quarkus.vault.client.api.sys.plugins.VaultSysPluginsListSecretResultData;
import io.quarkus.vault.client.api.sys.plugins.VaultSysPluginsPluginInfo;
import io.quarkus.vault.client.api.sys.plugins.VaultSysPluginsRegisterParams;
import io.quarkus.vault.client.api.sys.plugins.VaultSysPluginsRequestFactory;
import io.quarkus.vault.client.common.VaultRequestExecutor;
import io.quarkus.vault.client.common.VaultResponse;
import java.util.List;
import java.util.concurrent.CompletionStage;

public class VaultSysPlugins
extends VaultAPI<VaultSysPluginsRequestFactory> {
    public static VaultSysPluginsRequestFactory FACTORY = VaultSysPluginsRequestFactory.INSTANCE;

    public VaultSysPlugins(VaultRequestExecutor executor, VaultSysPluginsRequestFactory factory) {
        super(executor, factory);
    }

    public VaultSysPlugins(VaultRequestExecutor executor) {
        this(executor, FACTORY);
    }

    public CompletionStage<VaultSysPluginsListResultData> list() {
        return this.executor.execute(((VaultSysPluginsRequestFactory)this.factory).list()).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<List<String>> listAuth() {
        return this.executor.execute(((VaultSysPluginsRequestFactory)this.factory).listAuth()).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSysPluginsListAuthResultData)r.getData()).getKeys());
    }

    public CompletionStage<List<String>> listDatabase() {
        return this.executor.execute(((VaultSysPluginsRequestFactory)this.factory).listDatabase()).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSysPluginsListDatabaseResultData)r.getData()).getKeys());
    }

    public CompletionStage<List<String>> listSecret() {
        return this.executor.execute(((VaultSysPluginsRequestFactory)this.factory).listSecret()).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultSysPluginsListSecretResultData)r.getData()).getKeys());
    }

    public CompletionStage<VaultSysPluginsPluginInfo> read(String type, String name, String version) {
        return this.executor.execute(((VaultSysPluginsRequestFactory)this.factory).read(type, name, version)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultSysPluginsPluginInfo> read(String type, String name) {
        return this.executor.execute(((VaultSysPluginsRequestFactory)this.factory).read(type, name)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<Void> register(String type, String name, VaultSysPluginsRegisterParams params) {
        return this.executor.execute(((VaultSysPluginsRequestFactory)this.factory).register(type, name, params)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> remove(String type, String name, String version) {
        return this.executor.execute(((VaultSysPluginsRequestFactory)this.factory).remove(type, name, version)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> remove(String type, String name) {
        return this.executor.execute(((VaultSysPluginsRequestFactory)this.factory).remove(type, name)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> reloadPlugin(String plugin, String scope) {
        return this.executor.execute(((VaultSysPluginsRequestFactory)this.factory).reloadPlugin(plugin, scope)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> reloadMounts(List<String> mounts, String scope) {
        return this.executor.execute(((VaultSysPluginsRequestFactory)this.factory).reloadMounts(mounts, scope)).thenApply(VaultResponse::getResult);
    }
}

