/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.sys.policy;

import io.quarkus.vault.client.api.common.VaultRequestFactory;
import io.quarkus.vault.client.api.sys.policy.VaultSysPolicyListResult;
import io.quarkus.vault.client.api.sys.policy.VaultSysPolicyReadResult;
import io.quarkus.vault.client.api.sys.policy.VaultSysPolicyUpdateParams;
import io.quarkus.vault.client.common.VaultLeasedResultExtractor;
import io.quarkus.vault.client.common.VaultRequest;

public class VaultSysPolicyRequestFactory
extends VaultRequestFactory {
    public static final VaultSysPolicyRequestFactory INSTANCE = new VaultSysPolicyRequestFactory();

    public VaultSysPolicyRequestFactory() {
        super("[SYS (policy)]");
    }

    public VaultRequest<VaultSysPolicyListResult> list() {
        return VaultRequest.get(this.getTraceOpName("List")).path("sys", "policy").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSysPolicyListResult.class));
    }

    public VaultRequest<VaultSysPolicyReadResult> read(String name) {
        return VaultRequest.get(this.getTraceOpName("Read")).path("sys", "policy", name).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultSysPolicyReadResult.class));
    }

    public VaultRequest<Void> update(String name, String policy) {
        return VaultRequest.post(this.getTraceOpName("Update")).path("sys", "policy", name).body(new VaultSysPolicyUpdateParams().setPolicy(policy)).expectNoContentStatus().build();
    }

    public VaultRequest<Void> delete(String name) {
        return VaultRequest.delete(this.getTraceOpName("Delete")).path("sys", "policy", name).expectNoContentStatus().build();
    }
}

