/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.sys.seal;

import io.quarkus.vault.client.api.common.VaultRequestFactory;
import io.quarkus.vault.client.api.sys.seal.VaultSysSealBackendStatusResult;
import io.quarkus.vault.client.api.sys.seal.VaultSysSealStatusResult;
import io.quarkus.vault.client.api.sys.seal.VaultSysSealUnsealParams;
import io.quarkus.vault.client.common.VaultJSONResultExtractor;
import io.quarkus.vault.client.common.VaultRequest;

public class VaultSysSealRequestFactory
extends VaultRequestFactory {
    public static final VaultSysSealRequestFactory INSTANCE = new VaultSysSealRequestFactory();

    public VaultSysSealRequestFactory() {
        super("[SYS (seal)]");
    }

    public VaultRequest<VaultSysSealStatusResult> status() {
        return VaultRequest.get(this.getTraceOpName("Status")).path("sys", "seal-status").noNamespace().expectOkStatus().build(VaultJSONResultExtractor.of(VaultSysSealStatusResult.class));
    }

    public VaultRequest<VaultSysSealBackendStatusResult> backendStatus() {
        return VaultRequest.get(this.getTraceOpName("Backend Status")).path("sys", "seal-backend-status").noNamespace().expectOkStatus().build(VaultJSONResultExtractor.of(VaultSysSealBackendStatusResult.class));
    }

    public VaultRequest<Void> seal() {
        return VaultRequest.post(this.getTraceOpName("Seal")).path("sys", "seal").expectNoContentStatus().build();
    }

    public VaultRequest<VaultSysSealStatusResult> unseal(String key, Boolean reset, Boolean migrate) {
        return VaultRequest.post(this.getTraceOpName("Unseal")).path("sys", "unseal").body(new VaultSysSealUnsealParams().setKey(key).setReset(reset).setMigrate(migrate)).expectOkStatus().build(VaultJSONResultExtractor.of(VaultSysSealStatusResult.class));
    }
}

