/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.auth;

import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRole;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleLoginAuthResult;
import io.quarkus.vault.client.auth.VaultAppRoleAuthOptions;
import io.quarkus.vault.client.auth.VaultAuthRequest;
import io.quarkus.vault.client.auth.VaultToken;
import io.quarkus.vault.client.auth.VaultTokenProvider;
import io.quarkus.vault.client.common.VaultRequestExecutor;
import io.quarkus.vault.client.common.VaultResponse;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public class VaultAppRoleTokenProvider
implements VaultTokenProvider {
    private final String mountPath;
    private final String roleId;
    private final Function<VaultAuthRequest, CompletionStage<String>> secretIdProvider;

    public VaultAppRoleTokenProvider(String mountPath, String roleId, Function<VaultAuthRequest, CompletionStage<String>> secretIdProvider) {
        this.mountPath = mountPath;
        this.roleId = roleId;
        this.secretIdProvider = secretIdProvider;
    }

    public VaultAppRoleTokenProvider(VaultAppRoleAuthOptions options) {
        this(options.mountPath, options.roleId, options.secretIdProvider);
    }

    @Override
    public CompletionStage<VaultToken> apply(VaultAuthRequest authRequest) {
        VaultRequestExecutor executor = authRequest.getExecutor();
        return this.secretIdProvider.apply(authRequest).thenCompose(secretId -> executor.execute(VaultAuthAppRole.FACTORY.login(this.mountPath, this.roleId, (String)secretId))).thenApply(VaultResponse::getResult).thenApply(res -> {
            VaultAuthAppRoleLoginAuthResult auth = (VaultAuthAppRoleLoginAuthResult)res.getAuth();
            return VaultToken.from(auth.getClientToken(), auth.isRenewable(), auth.getLeaseDuration(), authRequest.getInstantSource());
        });
    }
}

