/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.auth;

import io.quarkus.vault.client.auth.VaultTimeLimited;
import io.quarkus.vault.client.logging.LogConfidentialityLevel;
import java.time.Duration;
import java.time.Instant;
import java.time.InstantSource;

public class VaultToken
extends VaultTimeLimited {
    private final String clientToken;
    private final boolean fromCache;

    public static VaultToken from(String clientToken, boolean renewable, Duration leaseDuration, InstantSource instantSource) {
        return new VaultToken(clientToken, renewable, leaseDuration, false, instantSource);
    }

    public static VaultToken renewable(String clientToken, Duration leaseDuration, InstantSource instantSource) {
        return VaultToken.from(clientToken, true, leaseDuration, instantSource);
    }

    public static VaultToken neverExpires(String clientToken, InstantSource instantSource) {
        return VaultToken.from(clientToken, false, Duration.ofSeconds(Long.MAX_VALUE), instantSource);
    }

    public VaultToken(String clientToken, boolean renewable, Duration leaseDuration, boolean fromCache, InstantSource instantSource) {
        super(renewable, leaseDuration, instantSource);
        this.clientToken = clientToken;
        this.fromCache = fromCache;
    }

    public VaultToken(String clientToken, boolean renewable, Duration leaseDuration, Instant created, boolean fromCache, InstantSource instantSource) {
        super(renewable, leaseDuration, created, instantSource);
        this.clientToken = clientToken;
        this.fromCache = fromCache;
    }

    public VaultToken cached() {
        return new VaultToken(this.clientToken, this.isRenewable(), this.getLeaseDuration(), this.getCreated(), true, this.getInstantSource());
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public boolean isFromCache() {
        return this.fromCache;
    }

    public String getConfidentialInfo(LogConfidentialityLevel level) {
        return "{clientToken: " + level.maskWithTolerance(this.clientToken, LogConfidentialityLevel.LOW) + ", " + super.info() + "}";
    }
}

