/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.common;

import io.quarkus.vault.client.api.common.VaultLeasedResult;
import io.quarkus.vault.client.common.VaultJSONResultExtractor;
import io.quarkus.vault.client.common.VaultResponse;
import io.quarkus.vault.client.common.VaultResultExtractor;
import java.util.Optional;
import java.util.logging.Logger;

public class VaultLeasedResultExtractor<T extends VaultLeasedResult<?, ?>>
implements VaultResultExtractor<T> {
    private static final Logger log = Logger.getLogger(VaultLeasedResultExtractor.class.getName());
    private final Class<T> resultClass;

    public VaultLeasedResultExtractor(Class<T> resultClass) {
        this.resultClass = resultClass;
    }

    public static <T extends VaultLeasedResult<?, ?>> VaultLeasedResultExtractor<T> of(Class<T> resultClass) {
        return new VaultLeasedResultExtractor<T>(resultClass);
    }

    @Override
    public Optional<T> extract(VaultResponse<T> response) {
        Optional<VaultLeasedResult> extracted = VaultJSONResultExtractor.extract(response, this.resultClass);
        extracted.ifPresent(result -> {
            if (result.getWarnings() != null) {
                for (String warning : result.getWarnings()) {
                    log.warning(warning);
                }
            }
        });
        return extracted;
    }
}

