/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client;

import io.quarkus.vault.client.VaultClientException;
import io.quarkus.vault.client.auth.VaultToken;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;

class Retry<T>
implements Function<Integer, CompletionStage<T>> {
    private final Supplier<CompletionStage<T>> upstreamSupplier;
    private final long maxRetries;
    private final AtomicReference<VaultToken> appliedToken;

    public Retry(Supplier<CompletionStage<T>> upstreamSupplier, long maxRetries, AtomicReference<VaultToken> appliedToken) {
        assert (maxRetries > 0L);
        this.upstreamSupplier = Objects.requireNonNull(upstreamSupplier, "upstreamSupplier");
        this.maxRetries = maxRetries;
        this.appliedToken = appliedToken;
    }

    @Override
    public CompletionStage<T> apply(Integer attempt) {
        return this.upstreamSupplier.get().exceptionallyCompose(failure -> {
            if ((long)attempt.intValue() < this.maxRetries && this.shouldRetry((Throwable)failure)) {
                return this.apply(attempt + 1);
            }
            return CompletableFuture.failedFuture(failure);
        });
    }

    private boolean shouldRetry(Throwable failure) {
        if (failure instanceof CompletionException || failure instanceof ExecutionException) {
            failure = failure.getCause();
        }
        if (failure instanceof VaultClientException) {
            VaultClientException ve = (VaultClientException)failure;
            VaultToken token = this.appliedToken.get();
            return ve.isPermissionDenied() && token != null && token.isFromCache();
        }
        return false;
    }
}

