/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.auth.approle;

import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleCreateCustomSecretIdParams;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleCreateCustomSecretIdResultData;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleGenerateSecretIdParams;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleGenerateSecretIdResultData;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleListRolesResultData;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleListSecretIdAccessorsResultData;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleLoginAuthResult;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleReadRoleIdResultData;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleReadRoleResultData;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleReadSecretIdAccessorResultData;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleReadSecretIdResultData;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleRequestFactory;
import io.quarkus.vault.client.api.auth.approle.VaultAuthAppRoleUpdateRoleParams;
import io.quarkus.vault.client.api.common.VaultLeasedResult;
import io.quarkus.vault.client.api.common.VaultMountableAPI;
import io.quarkus.vault.client.common.VaultRequestExecutor;
import io.quarkus.vault.client.common.VaultResponse;
import java.util.List;
import java.util.concurrent.CompletionStage;

public class VaultAuthAppRole
extends VaultMountableAPI<VaultAuthAppRoleRequestFactory> {
    public static VaultAuthAppRoleRequestFactory FACTORY = VaultAuthAppRoleRequestFactory.INSTANCE;

    public VaultAuthAppRole(VaultRequestExecutor executor, String mountPath, VaultAuthAppRoleRequestFactory factory) {
        super(executor, factory, mountPath);
    }

    public VaultAuthAppRole(VaultRequestExecutor executor, String mountPath) {
        this(executor, mountPath, FACTORY);
    }

    public CompletionStage<VaultAuthAppRoleLoginAuthResult> login(String roleId, String secretId) {
        return this.executor.execute(((VaultAuthAppRoleRequestFactory)this.factory).login(this.mountPath, roleId, secretId)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getAuth);
    }

    public CompletionStage<List<String>> listRoles() {
        return this.executor.execute(((VaultAuthAppRoleRequestFactory)this.factory).listRoles(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultAuthAppRoleListRolesResultData)r.getData()).getKeys());
    }

    public CompletionStage<Void> updateRole(String roleName, VaultAuthAppRoleUpdateRoleParams params) {
        return this.executor.execute(((VaultAuthAppRoleRequestFactory)this.factory).updateRole(this.mountPath, roleName, params)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<VaultAuthAppRoleReadRoleResultData> readRole(String roleName) {
        return this.executor.execute(((VaultAuthAppRoleRequestFactory)this.factory).readRole(this.mountPath, roleName)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<Void> deleteRole(String roleName) {
        return this.executor.execute(((VaultAuthAppRoleRequestFactory)this.factory).deleteRole(this.mountPath, roleName)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<String> readRoleId(String roleName) {
        return this.executor.execute(((VaultAuthAppRoleRequestFactory)this.factory).readRoleId(this.mountPath, roleName)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultAuthAppRoleReadRoleIdResultData)r.getData()).getRoleId());
    }

    public CompletionStage<Void> updateRoleId(String roleName, String roleId) {
        return this.executor.execute(((VaultAuthAppRoleRequestFactory)this.factory).updateRoleId(this.mountPath, roleName, roleId)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<VaultAuthAppRoleGenerateSecretIdResultData> generateSecretId(String roleName, VaultAuthAppRoleGenerateSecretIdParams params) {
        return this.executor.execute(((VaultAuthAppRoleRequestFactory)this.factory).generateSecretId(this.mountPath, roleName, params)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<List<String>> listSecretIdAccessors(String roleName) {
        return this.executor.execute(((VaultAuthAppRoleRequestFactory)this.factory).listSecretIdAccessors(this.mountPath, roleName)).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultAuthAppRoleListSecretIdAccessorsResultData)r.getData()).getKeys());
    }

    public CompletionStage<VaultAuthAppRoleReadSecretIdResultData> readSecretId(String roleName, String secretId) {
        return this.executor.execute(((VaultAuthAppRoleRequestFactory)this.factory).readSecretId(this.mountPath, roleName, secretId)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<Void> destroySecretId(String roleName, String secretId) {
        return this.executor.execute(((VaultAuthAppRoleRequestFactory)this.factory).destroySecretId(this.mountPath, roleName, secretId)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<VaultAuthAppRoleCreateCustomSecretIdResultData> createCustomSecretId(String roleName, VaultAuthAppRoleCreateCustomSecretIdParams params) {
        return this.executor.execute(((VaultAuthAppRoleRequestFactory)this.factory).createCustomSecretId(this.mountPath, roleName, params)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultAuthAppRoleReadSecretIdAccessorResultData> readSecretIdAccessor(String roleName, String secretIdAccessor) {
        return this.executor.execute(((VaultAuthAppRoleRequestFactory)this.factory).readSecretIdAccessor(this.mountPath, roleName, secretIdAccessor)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<Void> destroySecretIdAccessor(String roleName, String secretIdAccessor) {
        return this.executor.execute(((VaultAuthAppRoleRequestFactory)this.factory).destroySecretIdAccessor(this.mountPath, roleName, secretIdAccessor)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> tidyTokens() {
        return this.executor.execute(((VaultAuthAppRoleRequestFactory)this.factory).tidyTokens(this.mountPath)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }
}

