/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.auth.kubernetes;

import io.quarkus.vault.client.api.auth.kubernetes.VaultAuthKubernetesConfigureParams;
import io.quarkus.vault.client.api.auth.kubernetes.VaultAuthKubernetesListRolesResult;
import io.quarkus.vault.client.api.auth.kubernetes.VaultAuthKubernetesLoginParams;
import io.quarkus.vault.client.api.auth.kubernetes.VaultAuthKubernetesLoginResult;
import io.quarkus.vault.client.api.auth.kubernetes.VaultAuthKubernetesReadConfigResult;
import io.quarkus.vault.client.api.auth.kubernetes.VaultAuthKubernetesReadRoleResult;
import io.quarkus.vault.client.api.auth.kubernetes.VaultAuthKubernetesUpdateRoleParams;
import io.quarkus.vault.client.api.common.VaultRequestFactory;
import io.quarkus.vault.client.common.VaultLeasedResultExtractor;
import io.quarkus.vault.client.common.VaultRequest;

public class VaultAuthKubernetesRequestFactory
extends VaultRequestFactory {
    public static final VaultAuthKubernetesRequestFactory INSTANCE = new VaultAuthKubernetesRequestFactory();

    public VaultAuthKubernetesRequestFactory() {
        super("[AUTH (k8s)]");
    }

    public VaultRequest<VaultAuthKubernetesLoginResult> login(String mountPath, String role, String jwt) {
        return VaultRequest.post(this.getTraceOpName("Login")).path("auth", mountPath, "login").noToken().body(new VaultAuthKubernetesLoginParams().setRole(role).setJwt(jwt)).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultAuthKubernetesLoginResult.class));
    }

    public VaultRequest<Void> configure(String mountPath, VaultAuthKubernetesConfigureParams params) {
        return VaultRequest.post(this.getTraceOpName("Configure")).path("auth", mountPath, "config").body(params).expectNoContentStatus().build();
    }

    public VaultRequest<VaultAuthKubernetesReadConfigResult> readConfig(String mountPath) {
        return VaultRequest.get(this.getTraceOpName("Read Config")).path("auth", mountPath, "config").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultAuthKubernetesReadConfigResult.class));
    }

    public VaultRequest<Void> updateRole(String mountPath, String roleName, VaultAuthKubernetesUpdateRoleParams params) {
        return VaultRequest.post(this.getTraceOpName("Update Role")).path("auth", mountPath, "role", roleName).body(params).expectNoContentStatus().build();
    }

    public VaultRequest<VaultAuthKubernetesReadRoleResult> readRole(String mountPath, String roleName) {
        return VaultRequest.get(this.getTraceOpName("Read Role")).path("auth", mountPath, "role", roleName).expectOkStatus().build(VaultLeasedResultExtractor.of(VaultAuthKubernetesReadRoleResult.class));
    }

    public VaultRequest<VaultAuthKubernetesListRolesResult> listRoles(String mountPath) {
        return VaultRequest.list(this.getTraceOpName("List Roles")).path("auth", mountPath, "role").expectOkStatus().build(VaultLeasedResultExtractor.of(VaultAuthKubernetesListRolesResult.class));
    }

    public VaultRequest<Void> deleteRole(String mountPath, String roleName) {
        return VaultRequest.delete(this.getTraceOpName("Delete Role")).path("auth", mountPath, "role", roleName).expectNoContentStatus().build();
    }
}

