/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.auth.token;

import io.quarkus.vault.client.api.auth.token.VaultAuthTokenCreateAuthResult;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenCreateTokenParams;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenListAccessorsResultData;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenListRolesResultData;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenReadRoleResultData;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenRenewAccessorAuthResult;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenRenewAuthResult;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenRenewSelfAuthResult;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenRequestFactory;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenTokenInfoData;
import io.quarkus.vault.client.api.auth.token.VaultAuthTokenUpdateRoleParams;
import io.quarkus.vault.client.api.common.VaultAPI;
import io.quarkus.vault.client.api.common.VaultLeasedResult;
import io.quarkus.vault.client.common.VaultRequestExecutor;
import io.quarkus.vault.client.common.VaultResponse;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletionStage;

public class VaultAuthToken
extends VaultAPI<VaultAuthTokenRequestFactory> {
    public static VaultAuthTokenRequestFactory FACTORY = VaultAuthTokenRequestFactory.INSTANCE;

    public VaultAuthToken(VaultRequestExecutor executor, VaultAuthTokenRequestFactory factory) {
        super(executor, factory);
    }

    public VaultAuthToken(VaultRequestExecutor executor) {
        this(executor, FACTORY);
    }

    public CompletionStage<List<String>> listAccessors() {
        return this.executor.execute(((VaultAuthTokenRequestFactory)this.factory).listAccessors()).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultAuthTokenListAccessorsResultData)r.getData()).getKeys());
    }

    public CompletionStage<VaultAuthTokenCreateAuthResult> create(boolean orphan, VaultAuthTokenCreateTokenParams params) {
        return this.executor.execute(((VaultAuthTokenRequestFactory)this.factory).create(orphan, params)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getAuth);
    }

    public CompletionStage<VaultAuthTokenCreateAuthResult> create(VaultAuthTokenCreateTokenParams params) {
        return this.executor.execute(((VaultAuthTokenRequestFactory)this.factory).create(params)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getAuth);
    }

    public CompletionStage<VaultAuthTokenCreateAuthResult> create(String roleName, VaultAuthTokenCreateTokenParams params) {
        return this.executor.execute(((VaultAuthTokenRequestFactory)this.factory).create(roleName, params)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getAuth);
    }

    public CompletionStage<VaultAuthTokenTokenInfoData> lookup(String token) {
        return this.executor.execute(((VaultAuthTokenRequestFactory)this.factory).lookup(token)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultAuthTokenTokenInfoData> lookupSelf() {
        return this.executor.execute(((VaultAuthTokenRequestFactory)this.factory).lookupSelf()).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultAuthTokenTokenInfoData> lookupAccessor(String accessor) {
        return this.executor.execute(((VaultAuthTokenRequestFactory)this.factory).lookupAccessor(accessor)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<VaultAuthTokenRenewAuthResult> renew(String token, Duration increment) {
        return this.executor.execute(((VaultAuthTokenRequestFactory)this.factory).renew(token, increment)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getAuth);
    }

    public CompletionStage<VaultAuthTokenRenewSelfAuthResult> renewSelf(Duration increment) {
        return this.executor.execute(((VaultAuthTokenRequestFactory)this.factory).renewSelf(increment)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getAuth);
    }

    public CompletionStage<VaultAuthTokenRenewAccessorAuthResult> renewAccessor(String accessor, Duration increment) {
        return this.executor.execute(((VaultAuthTokenRequestFactory)this.factory).renewAccessor(accessor, increment)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getAuth);
    }

    public CompletionStage<Void> revoke(boolean orphanChildren, String token) {
        return this.executor.execute(((VaultAuthTokenRequestFactory)this.factory).revoke(orphanChildren, token)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> revoke(String token) {
        return this.executor.execute(((VaultAuthTokenRequestFactory)this.factory).revoke(token)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> revokeSelf() {
        return this.executor.execute(((VaultAuthTokenRequestFactory)this.factory).revokeSelf()).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> revokeAccessor(String accessor) {
        return this.executor.execute(((VaultAuthTokenRequestFactory)this.factory).revokeAccessor(accessor)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<VaultAuthTokenReadRoleResultData> readRole(String roleName) {
        return this.executor.execute(((VaultAuthTokenRequestFactory)this.factory).readRole(roleName)).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }

    public CompletionStage<List<String>> listRoles() {
        return this.executor.execute(((VaultAuthTokenRequestFactory)this.factory).listRoles()).thenApply(VaultResponse::getResult).thenApply(r -> ((VaultAuthTokenListRolesResultData)r.getData()).getKeys());
    }

    public CompletionStage<Void> updateRole(String roleName, VaultAuthTokenUpdateRoleParams params) {
        return this.executor.execute(((VaultAuthTokenRequestFactory)this.factory).updateRole(roleName, params)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> deleteRole(String roleName) {
        return this.executor.execute(((VaultAuthTokenRequestFactory)this.factory).deleteRole(roleName)).thenApply(VaultResponse::getResult);
    }

    public CompletionStage<Void> tidyTokens() {
        return this.executor.execute(((VaultAuthTokenRequestFactory)this.factory).tidyTokens()).thenApply(VaultResponse::getResult).thenApply(VaultLeasedResult::getData);
    }
}

