/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.quarkus.vault.client.common.VaultModel;

public enum VaultFormat implements VaultModel
{
    BASE64("base64"),
    HEX("hex");

    private final String value;

    private VaultFormat(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    public static VaultFormat from(String value) {
        if (value == null) {
            return null;
        }
        for (VaultFormat v : VaultFormat.values()) {
            if (!v.value.equals(value)) continue;
            return v;
        }
        throw new IllegalArgumentException("Unknown value: " + value);
    }
}

