/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.client.api.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.quarkus.vault.client.common.VaultModel;

public enum VaultRandomSource implements VaultModel
{
    PLATFORM("platform"),
    SEAL("seal"),
    ALL("all");

    private final String value;

    private VaultRandomSource(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    public static VaultRandomSource from(String value) {
        if (value == null) {
            return null;
        }
        for (VaultRandomSource v : VaultRandomSource.values()) {
            if (!v.value.equals(value)) continue;
            return v;
        }
        throw new IllegalArgumentException("Unknown value: " + value);
    }
}

